angular.module('loomioApp').factory 'PollService', ($window, $location, AppConfig, Records, FormService, LmoUrlService, ScrollService, AbilityService, AttachmentService) ->
  new class PollService

    # NB: this is an intersection of data and code that's a little uncomfortable at the moment.
    # right now you can define polls in poll_templates.yml that won't come through in the interface unless
    # the right components are defined, or you could have components which don't have a matching poll type serverside.

    # Ideally, we write these proposal types as plugins, which say 'Hey, add these components,
    # and add this poll type to the yml data', at the same time.
    # This will also make it easier to switch poll types on and off per instance, and per group.

    activePollTemplates: ->
      # this could have group-specific logic later.
      AppConfig.pollTemplates

    fieldFromTemplate: (pollType, field) ->
      return unless template = @templateFor(pollType)
      template[field]

    templateFor: (pollType) ->
      @activePollTemplates()[pollType]

    lastStanceBy: (participant, poll) ->
      criteria =
        latest:    true
        pollId:    poll.id
      if AppConfig.currentUserId
        criteria.userId = AppConfig.currentUserId
      else if AppConfig.currentVisitorId
        criteria.visitorId = AppConfig.currentVisitorId
      _.first _.sortBy(Records.stances.find(criteria), 'createdAt')

    hasVoted: (participant, poll) ->
      @lastStanceBy(participant, poll)?

    iconFor: (poll) ->
      @fieldFromTemplate(poll.pollType, 'material_icon')

    usePollsFor: (model) ->
      model.group().features.use_polls && !$location.search().proposalView

    optionByName: (poll, name) ->
      _.find poll.pollOptions(), (option) -> option.name == name

    submitOutcome: (scope, model, options = {}) ->
      actionName = if scope.outcome.isNew() then 'created' else 'updated'
      FormService.submit(scope, model, _.merge(
        flashSuccess: "poll_common_outcome_form.outcome_#{actionName}"
        drafts: true
        failureCallback: ->
          ScrollService.scrollTo '.lmo-validation-error__message', container: '.poll-common-modal'
        successCallback: (data) ->
          scope.$emit 'outcomeSaved', data.outcomes[0].id
      , options))

    submitPoll: (scope, model, options = {}) ->
      actionName = if scope.poll.isNew() then 'created' else 'updated'
      FormService.submit(scope, model, _.merge(
        flashSuccess: "poll_#{model.pollType}_form.#{model.pollType}_#{actionName}"
        drafts: true
        prepareFn: ->
          scope.$emit 'processing'
        failureCallback: ->
          ScrollService.scrollTo '.lmo-validation-error__message', container: '.poll-common-modal'
        successCallback: (data) ->
          poll = Records.polls.find(data.polls[0].key)
          scope.$emit 'saveComplete', poll
          if actionName == 'created'
            $location.path(LmoUrlService.poll(poll))
          else
            AttachmentService.cleanupAfterUpdate(poll, 'poll')
        cleanupFn: ->
          scope.$emit 'doneProcessing'
      , options))

    submitStance: (scope, model, options = {}) ->
      actionName = if scope.stance.isNew() then 'created' else 'updated'
      pollType   = model.poll().pollType
      FormService.submit(scope, model, _.merge(
        flashSuccess: "poll_#{pollType}_vote_form.stance_#{actionName}"
        drafts: true
        prepareFn: ->
          scope.$emit 'processing'
        successCallback: (data) ->
          model.poll().clearStaleStances()
          AppConfig.currentVisitorId = data.stances[0].visitor_id
          ScrollService.scrollTo '.poll-common-card__results-shown'
          scope.$emit 'stanceSaved', data.stances[0].key
        cleanupFn: ->
          scope.$emit 'doneProcessing'
      , options))
