// -*- C++ -*-
/* These are functions for the libctl front-end which are exported
   via SWIG. */

vector3 vec_to_vector3(const meep::vec &v);
meep::vec vector3_to_vec(const vector3 v3);
void set_dimensions(int dims);

meep::structure *make_structure(int dims, vector3 size, vector3 center,
				double resolution, bool enable_averaging,
				double subpixel_tol, int subpixel_maxeval,
				bool ensure_periodicity_p,
				ctlio::geometric_object_list geometry,
				ctlio::material_type_list extra_materials,
				ctlio::material_type default_mat,
				ctlio::pml_list pml_layers,
				ctlio::symmetry_list symmetries,
				int num_chunks, double Courant);

ctlio::cvector3_list do_harminv(ctlio::cnumber_list vals, double dt, 
				double fmin, double fmax, int maxbands);

ctlio::number_list dft_flux_flux(meep::dft_flux *f);

// wrapper around constructor to fool SWIG
meep::geometric_volume_list
  *make_geometric_volume_list(const meep::geometric_volume &gv,
			      int c, complex<double> weight,
			      meep::geometric_volume_list *next);
