// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL.Account
{
	public partial class TLAccountPasswordInputSettings : TLObject 
	{
		[Flags]
		public enum Flag : Int32
		{
			NewSalt = (1 << 0),
			NewPasswordHash = (1 << 0),
			Hint = (1 << 0),
			Email = (1 << 1),
		}

		public bool HasNewSalt { get { return Flags.HasFlag(Flag.NewSalt); } set { Flags = value ? (Flags | Flag.NewSalt) : (Flags & ~Flag.NewSalt); } }
		public bool HasNewPasswordHash { get { return Flags.HasFlag(Flag.NewPasswordHash); } set { Flags = value ? (Flags | Flag.NewPasswordHash) : (Flags & ~Flag.NewPasswordHash); } }
		public bool HasHint { get { return Flags.HasFlag(Flag.Hint); } set { Flags = value ? (Flags | Flag.Hint) : (Flags & ~Flag.Hint); } }
		public bool HasEmail { get { return Flags.HasFlag(Flag.Email); } set { Flags = value ? (Flags | Flag.Email) : (Flags & ~Flag.Email); } }

		public Flag Flags { get; set; }
		public Byte[] NewSalt { get; set; }
		public Byte[] NewPasswordHash { get; set; }
		public String Hint { get; set; }
		public String Email { get; set; }

		public TLAccountPasswordInputSettings() { }
		public TLAccountPasswordInputSettings(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.AccountPasswordInputSettings; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			if (HasNewSalt) NewSalt = from.ReadByteArray();
			if (HasNewPasswordHash) NewPasswordHash = from.ReadByteArray();
			if (HasHint) Hint = from.ReadString();
			if (HasEmail) Email = from.ReadString();
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			if (HasNewSalt) to.WriteByteArray(NewSalt);
			if (HasNewPasswordHash) to.WriteByteArray(NewPasswordHash);
			if (HasHint) to.WriteString(Hint ?? string.Empty);
			if (HasEmail) to.WriteString(Email ?? string.Empty);
		}

		private void UpdateFlags()
		{
			HasNewSalt = NewSalt != null;
			HasNewPasswordHash = NewPasswordHash != null;
			HasHint = Hint != null;
			HasEmail = Email != null;
		}
	}
}