// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL.Auth.Methods
{
	/// <summary>
	/// RCP method auth.sendCode.
	/// Returns <see cref="Telegram.Api.TL.TLAuthSentCode"/>
	/// </summary>
	public partial class TLAuthSendCode : TLObject
	{
		[Flags]
		public enum Flag : Int32
		{
			AllowFlashcall = (1 << 0),
			CurrentNumber = (1 << 0),
		}

		public bool IsAllowFlashcall { get { return Flags.HasFlag(Flag.AllowFlashcall); } set { Flags = value ? (Flags | Flag.AllowFlashcall) : (Flags & ~Flag.AllowFlashcall); } }
		public bool HasCurrentNumber { get { return Flags.HasFlag(Flag.CurrentNumber); } set { Flags = value ? (Flags | Flag.CurrentNumber) : (Flags & ~Flag.CurrentNumber); } }

		public Flag Flags { get; set; }
		public String PhoneNumber { get; set; }
		public Boolean? CurrentNumber { get; set; }
		public Int32 ApiId { get; set; }
		public String ApiHash { get; set; }

		public TLAuthSendCode() { }
		public TLAuthSendCode(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.AuthSendCode; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			PhoneNumber = from.ReadString();
			if (HasCurrentNumber) CurrentNumber = from.ReadBoolean();
			ApiId = from.ReadInt32();
			ApiHash = from.ReadString();
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteString(PhoneNumber ?? string.Empty);
			if (HasCurrentNumber) to.WriteBoolean(CurrentNumber.Value);
			to.WriteInt32(ApiId);
			to.WriteString(ApiHash ?? string.Empty);
		}

		private void UpdateFlags()
		{
			HasCurrentNumber = CurrentNumber != null;
		}
	}
}