// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL.Channels.Methods
{
	/// <summary>
	/// RCP method channels.getAdminLog.
	/// Returns <see cref="Telegram.Api.TL.TLChannelsAdminLogResults"/>
	/// </summary>
	public partial class TLChannelsGetAdminLog : TLObject
	{
		[Flags]
		public enum Flag : Int32
		{
			EventsFilter = (1 << 0),
			Admins = (1 << 1),
		}

		public bool HasEventsFilter { get { return Flags.HasFlag(Flag.EventsFilter); } set { Flags = value ? (Flags | Flag.EventsFilter) : (Flags & ~Flag.EventsFilter); } }
		public bool HasAdmins { get { return Flags.HasFlag(Flag.Admins); } set { Flags = value ? (Flags | Flag.Admins) : (Flags & ~Flag.Admins); } }

		public Flag Flags { get; set; }
		public TLInputChannelBase Channel { get; set; }
		public String Q { get; set; }
		public TLChannelAdminLogEventsFilter EventsFilter { get; set; }
		public TLVector<TLInputUserBase> Admins { get; set; }
		public Int64 MaxId { get; set; }
		public Int64 MinId { get; set; }
		public Int32 Limit { get; set; }

		public TLChannelsGetAdminLog() { }
		public TLChannelsGetAdminLog(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.ChannelsGetAdminLog; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Channel = TLFactory.Read<TLInputChannelBase>(from);
			Q = from.ReadString();
			if (HasEventsFilter) EventsFilter = TLFactory.Read<TLChannelAdminLogEventsFilter>(from);
			if (HasAdmins) Admins = TLFactory.Read<TLVector<TLInputUserBase>>(from);
			MaxId = from.ReadInt64();
			MinId = from.ReadInt64();
			Limit = from.ReadInt32();
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteObject(Channel);
			to.WriteString(Q ?? string.Empty);
			if (HasEventsFilter) to.WriteObject(EventsFilter);
			if (HasAdmins) to.WriteObject(Admins);
			to.WriteInt64(MaxId);
			to.WriteInt64(MinId);
			to.WriteInt32(Limit);
		}

		private void UpdateFlags()
		{
			HasEventsFilter = EventsFilter != null;
			HasAdmins = Admins != null;
		}
	}
}