// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL.Messages.Methods
{
	/// <summary>
	/// RCP method messages.editInlineBotMessage.
	/// Returns <see cref="Telegram.Api.TL.TLBool"/>
	/// </summary>
	public partial class TLMessagesEditInlineBotMessage : TLObject
	{
		[Flags]
		public enum Flag : Int32
		{
			NoWebPage = (1 << 1),
			StopGeoLive = (1 << 12),
			Message = (1 << 11),
			ReplyMarkup = (1 << 2),
			Entities = (1 << 3),
			GeoPoint = (1 << 13),
		}

		public bool IsNoWebPage { get { return Flags.HasFlag(Flag.NoWebPage); } set { Flags = value ? (Flags | Flag.NoWebPage) : (Flags & ~Flag.NoWebPage); } }
		public bool IsStopGeoLive { get { return Flags.HasFlag(Flag.StopGeoLive); } set { Flags = value ? (Flags | Flag.StopGeoLive) : (Flags & ~Flag.StopGeoLive); } }
		public bool HasMessage { get { return Flags.HasFlag(Flag.Message); } set { Flags = value ? (Flags | Flag.Message) : (Flags & ~Flag.Message); } }
		public bool HasReplyMarkup { get { return Flags.HasFlag(Flag.ReplyMarkup); } set { Flags = value ? (Flags | Flag.ReplyMarkup) : (Flags & ~Flag.ReplyMarkup); } }
		public bool HasEntities { get { return Flags.HasFlag(Flag.Entities); } set { Flags = value ? (Flags | Flag.Entities) : (Flags & ~Flag.Entities); } }
		public bool HasGeoPoint { get { return Flags.HasFlag(Flag.GeoPoint); } set { Flags = value ? (Flags | Flag.GeoPoint) : (Flags & ~Flag.GeoPoint); } }

		public Flag Flags { get; set; }
		public TLInputBotInlineMessageID Id { get; set; }
		public String Message { get; set; }
		public TLReplyMarkupBase ReplyMarkup { get; set; }
		public TLVector<TLMessageEntityBase> Entities { get; set; }
		public TLInputGeoPointBase GeoPoint { get; set; }

		public TLMessagesEditInlineBotMessage() { }
		public TLMessagesEditInlineBotMessage(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.MessagesEditInlineBotMessage; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Id = TLFactory.Read<TLInputBotInlineMessageID>(from);
			if (HasMessage) Message = from.ReadString();
			if (HasReplyMarkup) ReplyMarkup = TLFactory.Read<TLReplyMarkupBase>(from);
			if (HasEntities) Entities = TLFactory.Read<TLVector<TLMessageEntityBase>>(from);
			if (HasGeoPoint) GeoPoint = TLFactory.Read<TLInputGeoPointBase>(from);
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteObject(Id);
			if (HasMessage) to.WriteString(Message ?? string.Empty);
			if (HasReplyMarkup) to.WriteObject(ReplyMarkup);
			if (HasEntities) to.WriteObject(Entities);
			if (HasGeoPoint) to.WriteObject(GeoPoint);
		}

		private void UpdateFlags()
		{
			HasMessage = Message != null;
			HasReplyMarkup = ReplyMarkup != null;
			HasEntities = Entities != null;
			HasGeoPoint = GeoPoint != null;
		}
	}
}