// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL.Messages.Methods
{
	/// <summary>
	/// RCP method messages.sendInlineBotResult.
	/// Returns <see cref="Telegram.Api.TL.TLUpdatesBase"/>
	/// </summary>
	public partial class TLMessagesSendInlineBotResult : TLObject
	{
		[Flags]
		public enum Flag : Int32
		{
			Silent = (1 << 5),
			Background = (1 << 6),
			ClearDraft = (1 << 7),
			ReplyToMsgId = (1 << 0),
		}

		public bool IsSilent { get { return Flags.HasFlag(Flag.Silent); } set { Flags = value ? (Flags | Flag.Silent) : (Flags & ~Flag.Silent); } }
		public bool IsBackground { get { return Flags.HasFlag(Flag.Background); } set { Flags = value ? (Flags | Flag.Background) : (Flags & ~Flag.Background); } }
		public bool IsClearDraft { get { return Flags.HasFlag(Flag.ClearDraft); } set { Flags = value ? (Flags | Flag.ClearDraft) : (Flags & ~Flag.ClearDraft); } }
		public bool HasReplyToMsgId { get { return Flags.HasFlag(Flag.ReplyToMsgId); } set { Flags = value ? (Flags | Flag.ReplyToMsgId) : (Flags & ~Flag.ReplyToMsgId); } }

		public Flag Flags { get; set; }
		public TLInputPeerBase Peer { get; set; }
		public Int32? ReplyToMsgId { get; set; }
		public Int64 RandomId { get; set; }
		public Int64 QueryId { get; set; }
		public String Id { get; set; }

		public TLMessagesSendInlineBotResult() { }
		public TLMessagesSendInlineBotResult(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.MessagesSendInlineBotResult; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Peer = TLFactory.Read<TLInputPeerBase>(from);
			if (HasReplyToMsgId) ReplyToMsgId = from.ReadInt32();
			RandomId = from.ReadInt64();
			QueryId = from.ReadInt64();
			Id = from.ReadString();
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteObject(Peer);
			if (HasReplyToMsgId) to.WriteInt32(ReplyToMsgId.Value);
			to.WriteInt64(RandomId);
			to.WriteInt64(QueryId);
			to.WriteString(Id ?? string.Empty);
		}

		private void UpdateFlags()
		{
			HasReplyToMsgId = ReplyToMsgId != null;
		}
	}
}