// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL.Messages.Methods
{
	/// <summary>
	/// RCP method messages.sendMessage.
	/// Returns <see cref="Telegram.Api.TL.TLUpdatesBase"/>
	/// </summary>
	public partial class TLMessagesSendMessage : TLObject
	{
		[Flags]
		public enum Flag : Int32
		{
			NoWebPage = (1 << 1),
			Silent = (1 << 5),
			Background = (1 << 6),
			ClearDraft = (1 << 7),
			ReplyToMsgId = (1 << 0),
			ReplyMarkup = (1 << 2),
			Entities = (1 << 3),
		}

		public bool IsNoWebPage { get { return Flags.HasFlag(Flag.NoWebPage); } set { Flags = value ? (Flags | Flag.NoWebPage) : (Flags & ~Flag.NoWebPage); } }
		public bool IsSilent { get { return Flags.HasFlag(Flag.Silent); } set { Flags = value ? (Flags | Flag.Silent) : (Flags & ~Flag.Silent); } }
		public bool IsBackground { get { return Flags.HasFlag(Flag.Background); } set { Flags = value ? (Flags | Flag.Background) : (Flags & ~Flag.Background); } }
		public bool IsClearDraft { get { return Flags.HasFlag(Flag.ClearDraft); } set { Flags = value ? (Flags | Flag.ClearDraft) : (Flags & ~Flag.ClearDraft); } }
		public bool HasReplyToMsgId { get { return Flags.HasFlag(Flag.ReplyToMsgId); } set { Flags = value ? (Flags | Flag.ReplyToMsgId) : (Flags & ~Flag.ReplyToMsgId); } }
		public bool HasReplyMarkup { get { return Flags.HasFlag(Flag.ReplyMarkup); } set { Flags = value ? (Flags | Flag.ReplyMarkup) : (Flags & ~Flag.ReplyMarkup); } }
		public bool HasEntities { get { return Flags.HasFlag(Flag.Entities); } set { Flags = value ? (Flags | Flag.Entities) : (Flags & ~Flag.Entities); } }

		public Flag Flags { get; set; }
		public TLInputPeerBase Peer { get; set; }
		public Int32? ReplyToMsgId { get; set; }
		public String Message { get; set; }
		public Int64 RandomId { get; set; }
		public TLReplyMarkupBase ReplyMarkup { get; set; }
		public TLVector<TLMessageEntityBase> Entities { get; set; }

		public TLMessagesSendMessage() { }
		public TLMessagesSendMessage(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.MessagesSendMessage; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Peer = TLFactory.Read<TLInputPeerBase>(from);
			if (HasReplyToMsgId) ReplyToMsgId = from.ReadInt32();
			Message = from.ReadString();
			RandomId = from.ReadInt64();
			if (HasReplyMarkup) ReplyMarkup = TLFactory.Read<TLReplyMarkupBase>(from);
			if (HasEntities) Entities = TLFactory.Read<TLVector<TLMessageEntityBase>>(from);
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteObject(Peer);
			if (HasReplyToMsgId) to.WriteInt32(ReplyToMsgId.Value);
			to.WriteString(Message ?? string.Empty);
			to.WriteInt64(RandomId);
			if (HasReplyMarkup) to.WriteObject(ReplyMarkup);
			if (HasEntities) to.WriteObject(Entities);
		}

		private void UpdateFlags()
		{
			HasReplyToMsgId = ReplyToMsgId != null;
			HasReplyMarkup = ReplyMarkup != null;
			HasEntities = Entities != null;
		}
	}
}