// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL.Messages.Methods
{
	/// <summary>
	/// RCP method messages.sendMultiMedia.
	/// Returns <see cref="Telegram.Api.TL.TLUpdatesBase"/>
	/// </summary>
	public partial class TLMessagesSendMultiMedia : TLObject
	{
		[Flags]
		public enum Flag : Int32
		{
			Silent = (1 << 5),
			Background = (1 << 6),
			ClearDraft = (1 << 7),
			ReplyToMsgId = (1 << 0),
		}

		public bool IsSilent { get { return Flags.HasFlag(Flag.Silent); } set { Flags = value ? (Flags | Flag.Silent) : (Flags & ~Flag.Silent); } }
		public bool IsBackground { get { return Flags.HasFlag(Flag.Background); } set { Flags = value ? (Flags | Flag.Background) : (Flags & ~Flag.Background); } }
		public bool IsClearDraft { get { return Flags.HasFlag(Flag.ClearDraft); } set { Flags = value ? (Flags | Flag.ClearDraft) : (Flags & ~Flag.ClearDraft); } }
		public bool HasReplyToMsgId { get { return Flags.HasFlag(Flag.ReplyToMsgId); } set { Flags = value ? (Flags | Flag.ReplyToMsgId) : (Flags & ~Flag.ReplyToMsgId); } }

		public Flag Flags { get; set; }
		public TLInputPeerBase Peer { get; set; }
		public Int32? ReplyToMsgId { get; set; }
		public TLVector<TLInputSingleMedia> MultiMedia { get; set; }

		public TLMessagesSendMultiMedia() { }
		public TLMessagesSendMultiMedia(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.MessagesSendMultiMedia; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Peer = TLFactory.Read<TLInputPeerBase>(from);
			if (HasReplyToMsgId) ReplyToMsgId = from.ReadInt32();
			MultiMedia = TLFactory.Read<TLVector<TLInputSingleMedia>>(from);
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteObject(Peer);
			if (HasReplyToMsgId) to.WriteInt32(ReplyToMsgId.Value);
			to.WriteObject(MultiMedia);
		}

		private void UpdateFlags()
		{
			HasReplyToMsgId = ReplyToMsgId != null;
		}
	}
}