// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL.Payments
{
	public partial class TLPaymentsPaymentReceipt : TLObject 
	{
		[Flags]
		public enum Flag : Int32
		{
			Info = (1 << 0),
			Shipping = (1 << 1),
		}

		public bool HasInfo { get { return Flags.HasFlag(Flag.Info); } set { Flags = value ? (Flags | Flag.Info) : (Flags & ~Flag.Info); } }
		public bool HasShipping { get { return Flags.HasFlag(Flag.Shipping); } set { Flags = value ? (Flags | Flag.Shipping) : (Flags & ~Flag.Shipping); } }

		public Flag Flags { get; set; }
		public Int32 Date { get; set; }
		public Int32 BotId { get; set; }
		public TLInvoice Invoice { get; set; }
		public Int32 ProviderId { get; set; }
		public TLPaymentRequestedInfo Info { get; set; }
		public TLShippingOption Shipping { get; set; }
		public String Currency { get; set; }
		public Int64 TotalAmount { get; set; }
		public String CredentialsTitle { get; set; }
		public TLVector<TLUserBase> Users { get; set; }

		public TLPaymentsPaymentReceipt() { }
		public TLPaymentsPaymentReceipt(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.PaymentsPaymentReceipt; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Date = from.ReadInt32();
			BotId = from.ReadInt32();
			Invoice = TLFactory.Read<TLInvoice>(from);
			ProviderId = from.ReadInt32();
			if (HasInfo) Info = TLFactory.Read<TLPaymentRequestedInfo>(from);
			if (HasShipping) Shipping = TLFactory.Read<TLShippingOption>(from);
			Currency = from.ReadString();
			TotalAmount = from.ReadInt64();
			CredentialsTitle = from.ReadString();
			Users = TLFactory.Read<TLVector<TLUserBase>>(from);
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteInt32(Date);
			to.WriteInt32(BotId);
			to.WriteObject(Invoice);
			to.WriteInt32(ProviderId);
			if (HasInfo) to.WriteObject(Info);
			if (HasShipping) to.WriteObject(Shipping);
			to.WriteString(Currency ?? string.Empty);
			to.WriteInt64(TotalAmount);
			to.WriteString(CredentialsTitle ?? string.Empty);
			to.WriteObject(Users);
		}

		private void UpdateFlags()
		{
			HasInfo = Info != null;
			HasShipping = Shipping != null;
		}
	}
}