// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLBotInlineMediaResult : TLBotInlineResultBase 
	{
		[Flags]
		public enum Flag : Int32
		{
			Photo = (1 << 0),
			Document = (1 << 1),
			Title = (1 << 2),
			Description = (1 << 3),
		}

		public bool HasPhoto { get { return Flags.HasFlag(Flag.Photo); } set { Flags = value ? (Flags | Flag.Photo) : (Flags & ~Flag.Photo); } }
		public bool HasDocument { get { return Flags.HasFlag(Flag.Document); } set { Flags = value ? (Flags | Flag.Document) : (Flags & ~Flag.Document); } }
		public bool HasTitle { get { return Flags.HasFlag(Flag.Title); } set { Flags = value ? (Flags | Flag.Title) : (Flags & ~Flag.Title); } }
		public bool HasDescription { get { return Flags.HasFlag(Flag.Description); } set { Flags = value ? (Flags | Flag.Description) : (Flags & ~Flag.Description); } }

		public Flag Flags { get; set; }
		public TLPhotoBase Photo { get; set; }
		public TLDocumentBase Document { get; set; }

		public TLBotInlineMediaResult() { }
		public TLBotInlineMediaResult(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.BotInlineMediaResult; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Id = from.ReadString();
			Type = from.ReadString();
			if (HasPhoto) Photo = TLFactory.Read<TLPhotoBase>(from);
			if (HasDocument) Document = TLFactory.Read<TLDocumentBase>(from);
			if (HasTitle) Title = from.ReadString();
			if (HasDescription) Description = from.ReadString();
			SendMessage = TLFactory.Read<TLBotInlineMessageBase>(from);
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteString(Id ?? string.Empty);
			to.WriteString(Type ?? string.Empty);
			if (HasPhoto) to.WriteObject(Photo);
			if (HasDocument) to.WriteObject(Document);
			if (HasTitle) to.WriteString(Title ?? string.Empty);
			if (HasDescription) to.WriteString(Description ?? string.Empty);
			to.WriteObject(SendMessage);
		}

		private void UpdateFlags()
		{
			HasPhoto = Photo != null;
			HasDocument = Document != null;
			HasTitle = Title != null;
			HasDescription = Description != null;
		}
	}
}