// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLBotInlineMessageMediaVenue : TLBotInlineMessageBase 
	{
		[Flags]
		public enum Flag : Int32
		{
			ReplyMarkup = (1 << 2),
		}

		public bool HasReplyMarkup { get { return Flags.HasFlag(Flag.ReplyMarkup); } set { Flags = value ? (Flags | Flag.ReplyMarkup) : (Flags & ~Flag.ReplyMarkup); } }

		public Flag Flags { get; set; }
		public TLGeoPointBase Geo { get; set; }
		public String Title { get; set; }
		public String Address { get; set; }
		public String Provider { get; set; }
		public String VenueId { get; set; }

		public TLBotInlineMessageMediaVenue() { }
		public TLBotInlineMessageMediaVenue(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.BotInlineMessageMediaVenue; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Geo = TLFactory.Read<TLGeoPointBase>(from);
			Title = from.ReadString();
			Address = from.ReadString();
			Provider = from.ReadString();
			VenueId = from.ReadString();
			if (HasReplyMarkup) ReplyMarkup = TLFactory.Read<TLReplyMarkupBase>(from);
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteObject(Geo);
			to.WriteString(Title ?? string.Empty);
			to.WriteString(Address ?? string.Empty);
			to.WriteString(Provider ?? string.Empty);
			to.WriteString(VenueId ?? string.Empty);
			if (HasReplyMarkup) to.WriteObject(ReplyMarkup);
		}

		private void UpdateFlags()
		{
			HasReplyMarkup = ReplyMarkup != null;
		}
	}
}