// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLBotInlineMessageText : TLBotInlineMessageBase 
	{
		[Flags]
		public enum Flag : Int32
		{
			NoWebPage = (1 << 0),
			Entities = (1 << 1),
			ReplyMarkup = (1 << 2),
		}

		public bool IsNoWebPage { get { return Flags.HasFlag(Flag.NoWebPage); } set { Flags = value ? (Flags | Flag.NoWebPage) : (Flags & ~Flag.NoWebPage); } }
		public bool HasEntities { get { return Flags.HasFlag(Flag.Entities); } set { Flags = value ? (Flags | Flag.Entities) : (Flags & ~Flag.Entities); } }
		public bool HasReplyMarkup { get { return Flags.HasFlag(Flag.ReplyMarkup); } set { Flags = value ? (Flags | Flag.ReplyMarkup) : (Flags & ~Flag.ReplyMarkup); } }

		public Flag Flags { get; set; }
		public String Message { get; set; }
		public TLVector<TLMessageEntityBase> Entities { get; set; }

		public TLBotInlineMessageText() { }
		public TLBotInlineMessageText(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.BotInlineMessageText; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Message = from.ReadString();
			if (HasEntities) Entities = TLFactory.Read<TLVector<TLMessageEntityBase>>(from);
			if (HasReplyMarkup) ReplyMarkup = TLFactory.Read<TLReplyMarkupBase>(from);
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteString(Message ?? string.Empty);
			if (HasEntities) to.WriteObject(Entities);
			if (HasReplyMarkup) to.WriteObject(ReplyMarkup);
		}

		private void UpdateFlags()
		{
			HasEntities = Entities != null;
			HasReplyMarkup = ReplyMarkup != null;
		}
	}
}