// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLChannelForbidden : TLChatBase 
	{
		[Flags]
		public enum Flag : Int32
		{
			Broadcast = (1 << 5),
			MegaGroup = (1 << 8),
			UntilDate = (1 << 16),
		}

		public bool IsBroadcast { get { return Flags.HasFlag(Flag.Broadcast); } set { Flags = value ? (Flags | Flag.Broadcast) : (Flags & ~Flag.Broadcast); } }
		public bool IsMegaGroup { get { return Flags.HasFlag(Flag.MegaGroup); } set { Flags = value ? (Flags | Flag.MegaGroup) : (Flags & ~Flag.MegaGroup); } }
		public bool HasUntilDate { get { return Flags.HasFlag(Flag.UntilDate); } set { Flags = value ? (Flags | Flag.UntilDate) : (Flags & ~Flag.UntilDate); } }

		public Flag Flags { get; set; }
		public Int64 AccessHash { get; set; }
		public String Title { get; set; }
		public Int32? UntilDate { get; set; }

		public TLChannelForbidden() { }
		public TLChannelForbidden(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.ChannelForbidden; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Id = from.ReadInt32();
			AccessHash = from.ReadInt64();
			Title = from.ReadString();
			if (HasUntilDate) UntilDate = from.ReadInt32();
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteInt32(Id);
			to.WriteInt64(AccessHash);
			to.WriteString(Title ?? string.Empty);
			if (HasUntilDate) to.WriteInt32(UntilDate.Value);
		}

		private void UpdateFlags()
		{
			HasUntilDate = UntilDate != null;
		}
	}
}