// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLChannelFull : TLChatFullBase, ITLReadMaxId 
	{
		[Flags]
		public enum Flag : Int32
		{
			CanViewParticipants = (1 << 3),
			CanSetUsername = (1 << 6),
			CanSetStickers = (1 << 7),
			HiddenPreHistory = (1 << 10),
			ParticipantsCount = (1 << 0),
			AdminsCount = (1 << 1),
			KickedCount = (1 << 2),
			BannedCount = (1 << 2),
			MigratedFromChatId = (1 << 4),
			MigratedFromMaxId = (1 << 4),
			PinnedMsgId = (1 << 5),
			StickerSet = (1 << 8),
			AvailableMinId = (1 << 9),
		}

		public bool IsCanViewParticipants { get { return Flags.HasFlag(Flag.CanViewParticipants); } set { Flags = value ? (Flags | Flag.CanViewParticipants) : (Flags & ~Flag.CanViewParticipants); } }
		public bool IsCanSetUsername { get { return Flags.HasFlag(Flag.CanSetUsername); } set { Flags = value ? (Flags | Flag.CanSetUsername) : (Flags & ~Flag.CanSetUsername); } }
		public bool IsCanSetStickers { get { return Flags.HasFlag(Flag.CanSetStickers); } set { Flags = value ? (Flags | Flag.CanSetStickers) : (Flags & ~Flag.CanSetStickers); } }
		public bool IsHiddenPreHistory { get { return Flags.HasFlag(Flag.HiddenPreHistory); } set { Flags = value ? (Flags | Flag.HiddenPreHistory) : (Flags & ~Flag.HiddenPreHistory); } }
		public bool HasParticipantsCount { get { return Flags.HasFlag(Flag.ParticipantsCount); } set { Flags = value ? (Flags | Flag.ParticipantsCount) : (Flags & ~Flag.ParticipantsCount); } }
		public bool HasAdminsCount { get { return Flags.HasFlag(Flag.AdminsCount); } set { Flags = value ? (Flags | Flag.AdminsCount) : (Flags & ~Flag.AdminsCount); } }
		public bool HasKickedCount { get { return Flags.HasFlag(Flag.KickedCount); } set { Flags = value ? (Flags | Flag.KickedCount) : (Flags & ~Flag.KickedCount); } }
		public bool HasBannedCount { get { return Flags.HasFlag(Flag.BannedCount); } set { Flags = value ? (Flags | Flag.BannedCount) : (Flags & ~Flag.BannedCount); } }
		public bool HasMigratedFromChatId { get { return Flags.HasFlag(Flag.MigratedFromChatId); } set { Flags = value ? (Flags | Flag.MigratedFromChatId) : (Flags & ~Flag.MigratedFromChatId); } }
		public bool HasMigratedFromMaxId { get { return Flags.HasFlag(Flag.MigratedFromMaxId); } set { Flags = value ? (Flags | Flag.MigratedFromMaxId) : (Flags & ~Flag.MigratedFromMaxId); } }
		public bool HasPinnedMsgId { get { return Flags.HasFlag(Flag.PinnedMsgId); } set { Flags = value ? (Flags | Flag.PinnedMsgId) : (Flags & ~Flag.PinnedMsgId); } }
		public bool HasStickerSet { get { return Flags.HasFlag(Flag.StickerSet); } set { Flags = value ? (Flags | Flag.StickerSet) : (Flags & ~Flag.StickerSet); } }
		public bool HasAvailableMinId { get { return Flags.HasFlag(Flag.AvailableMinId); } set { Flags = value ? (Flags | Flag.AvailableMinId) : (Flags & ~Flag.AvailableMinId); } }

		public Flag Flags { get; set; }
		public String About { get; set; }
		public Int32? ParticipantsCount { get; set; }
		public Int32? AdminsCount { get; set; }
		public Int32? KickedCount { get; set; }
		public Int32? BannedCount { get; set; }
		public Int32 ReadInboxMaxId { get; set; }
		public Int32 ReadOutboxMaxId { get; set; }
		public Int32 UnreadCount { get; set; }
		public Int32? MigratedFromChatId { get; set; }
		public Int32? MigratedFromMaxId { get; set; }
		public Int32? PinnedMsgId { get; set; }
		public TLStickerSet StickerSet { get; set; }
		public Int32? AvailableMinId { get; set; }

		public TLChannelFull() { }
		public TLChannelFull(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.ChannelFull; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Id = from.ReadInt32();
			About = from.ReadString();
			if (HasParticipantsCount) ParticipantsCount = from.ReadInt32();
			if (HasAdminsCount) AdminsCount = from.ReadInt32();
			if (HasKickedCount) KickedCount = from.ReadInt32();
			if (HasBannedCount) BannedCount = from.ReadInt32();
			ReadInboxMaxId = from.ReadInt32();
			ReadOutboxMaxId = from.ReadInt32();
			UnreadCount = from.ReadInt32();
			ChatPhoto = TLFactory.Read<TLPhotoBase>(from);
			NotifySettings = TLFactory.Read<TLPeerNotifySettingsBase>(from);
			ExportedInvite = TLFactory.Read<TLExportedChatInviteBase>(from);
			BotInfo = TLFactory.Read<TLVector<TLBotInfo>>(from);
			if (HasMigratedFromChatId) MigratedFromChatId = from.ReadInt32();
			if (HasMigratedFromMaxId) MigratedFromMaxId = from.ReadInt32();
			if (HasPinnedMsgId) PinnedMsgId = from.ReadInt32();
			if (HasStickerSet) StickerSet = TLFactory.Read<TLStickerSet>(from);
			if (HasAvailableMinId) AvailableMinId = from.ReadInt32();
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteInt32(Id);
			to.WriteString(About ?? string.Empty);
			if (HasParticipantsCount) to.WriteInt32(ParticipantsCount.Value);
			if (HasAdminsCount) to.WriteInt32(AdminsCount.Value);
			if (HasKickedCount) to.WriteInt32(KickedCount.Value);
			if (HasBannedCount) to.WriteInt32(BannedCount.Value);
			to.WriteInt32(ReadInboxMaxId);
			to.WriteInt32(ReadOutboxMaxId);
			to.WriteInt32(UnreadCount);
			to.WriteObject(ChatPhoto);
			to.WriteObject(NotifySettings);
			to.WriteObject(ExportedInvite);
			to.WriteObject(BotInfo);
			if (HasMigratedFromChatId) to.WriteInt32(MigratedFromChatId.Value);
			if (HasMigratedFromMaxId) to.WriteInt32(MigratedFromMaxId.Value);
			if (HasPinnedMsgId) to.WriteInt32(PinnedMsgId.Value);
			if (HasStickerSet) to.WriteObject(StickerSet);
			if (HasAvailableMinId) to.WriteInt32(AvailableMinId.Value);
		}

		private void UpdateFlags()
		{
			HasParticipantsCount = ParticipantsCount != null;
			HasAdminsCount = AdminsCount != null;
			HasKickedCount = KickedCount != null;
			HasBannedCount = BannedCount != null;
			HasMigratedFromChatId = MigratedFromChatId != null;
			HasMigratedFromMaxId = MigratedFromMaxId != null;
			HasPinnedMsgId = PinnedMsgId != null;
			HasStickerSet = StickerSet != null;
			HasAvailableMinId = AvailableMinId != null;
		}
	}
}