// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLChat : TLChatBase 
	{
		[Flags]
		public enum Flag : Int32
		{
			Creator = (1 << 0),
			Kicked = (1 << 1),
			Left = (1 << 2),
			AdminsEnabled = (1 << 3),
			Admin = (1 << 4),
			Deactivated = (1 << 5),
			MigratedTo = (1 << 6),
		}

		public bool IsCreator { get { return Flags.HasFlag(Flag.Creator); } set { Flags = value ? (Flags | Flag.Creator) : (Flags & ~Flag.Creator); } }
		public bool IsKicked { get { return Flags.HasFlag(Flag.Kicked); } set { Flags = value ? (Flags | Flag.Kicked) : (Flags & ~Flag.Kicked); } }
		public bool IsLeft { get { return Flags.HasFlag(Flag.Left); } set { Flags = value ? (Flags | Flag.Left) : (Flags & ~Flag.Left); } }
		public bool IsAdminsEnabled { get { return Flags.HasFlag(Flag.AdminsEnabled); } set { Flags = value ? (Flags | Flag.AdminsEnabled) : (Flags & ~Flag.AdminsEnabled); } }
		public bool IsAdmin { get { return Flags.HasFlag(Flag.Admin); } set { Flags = value ? (Flags | Flag.Admin) : (Flags & ~Flag.Admin); } }
		public bool IsDeactivated { get { return Flags.HasFlag(Flag.Deactivated); } set { Flags = value ? (Flags | Flag.Deactivated) : (Flags & ~Flag.Deactivated); } }
		public bool HasMigratedTo { get { return Flags.HasFlag(Flag.MigratedTo); } set { Flags = value ? (Flags | Flag.MigratedTo) : (Flags & ~Flag.MigratedTo); } }

		public Flag Flags { get; set; }
		public String Title { get; set; }
		public TLChatPhotoBase Photo { get; set; }
		public Int32 ParticipantsCount { get; set; }
		public Int32 Date { get; set; }
		public Int32 Version { get; set; }
		public TLInputChannelBase MigratedTo { get; set; }

		public TLChat() { }
		public TLChat(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.Chat; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Id = from.ReadInt32();
			Title = from.ReadString();
			Photo = TLFactory.Read<TLChatPhotoBase>(from);
			ParticipantsCount = from.ReadInt32();
			Date = from.ReadInt32();
			Version = from.ReadInt32();
			if (HasMigratedTo) MigratedTo = TLFactory.Read<TLInputChannelBase>(from);
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteInt32(Id);
			to.WriteString(Title ?? string.Empty);
			to.WriteObject(Photo);
			to.WriteInt32(ParticipantsCount);
			to.WriteInt32(Date);
			to.WriteInt32(Version);
			if (HasMigratedTo) to.WriteObject(MigratedTo);
		}

		private void UpdateFlags()
		{
			HasMigratedTo = MigratedTo != null;
		}
	}
}