// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLChatInvite : TLChatInviteBase 
	{
		[Flags]
		public enum Flag : Int32
		{
			Channel = (1 << 0),
			Broadcast = (1 << 1),
			Public = (1 << 2),
			MegaGroup = (1 << 3),
			Participants = (1 << 4),
		}

		public bool IsChannel { get { return Flags.HasFlag(Flag.Channel); } set { Flags = value ? (Flags | Flag.Channel) : (Flags & ~Flag.Channel); } }
		public bool IsBroadcast { get { return Flags.HasFlag(Flag.Broadcast); } set { Flags = value ? (Flags | Flag.Broadcast) : (Flags & ~Flag.Broadcast); } }
		public bool IsPublic { get { return Flags.HasFlag(Flag.Public); } set { Flags = value ? (Flags | Flag.Public) : (Flags & ~Flag.Public); } }
		public bool IsMegaGroup { get { return Flags.HasFlag(Flag.MegaGroup); } set { Flags = value ? (Flags | Flag.MegaGroup) : (Flags & ~Flag.MegaGroup); } }
		public bool HasParticipants { get { return Flags.HasFlag(Flag.Participants); } set { Flags = value ? (Flags | Flag.Participants) : (Flags & ~Flag.Participants); } }

		public Flag Flags { get; set; }
		public String Title { get; set; }
		public TLChatPhotoBase Photo { get; set; }
		public Int32 ParticipantsCount { get; set; }
		public TLVector<TLUserBase> Participants { get; set; }

		public TLChatInvite() { }
		public TLChatInvite(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.ChatInvite; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Title = from.ReadString();
			Photo = TLFactory.Read<TLChatPhotoBase>(from);
			ParticipantsCount = from.ReadInt32();
			if (HasParticipants) Participants = TLFactory.Read<TLVector<TLUserBase>>(from);
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteString(Title ?? string.Empty);
			to.WriteObject(Photo);
			to.WriteInt32(ParticipantsCount);
			if (HasParticipants) to.WriteObject(Participants);
		}

		private void UpdateFlags()
		{
			HasParticipants = Participants != null;
		}
	}
}