// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLInputMediaInvoice : TLInputMediaBase 
	{
		[Flags]
		public enum Flag : Int32
		{
			Photo = (1 << 0),
		}

		public bool HasPhoto { get { return Flags.HasFlag(Flag.Photo); } set { Flags = value ? (Flags | Flag.Photo) : (Flags & ~Flag.Photo); } }

		public Flag Flags { get; set; }
		public String Title { get; set; }
		public String Description { get; set; }
		public TLInputWebDocument Photo { get; set; }
		public TLInvoice Invoice { get; set; }
		public Byte[] Payload { get; set; }
		public String Provider { get; set; }
		public TLDataJSON ProviderData { get; set; }
		public String StartParam { get; set; }

		public TLInputMediaInvoice() { }
		public TLInputMediaInvoice(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.InputMediaInvoice; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Title = from.ReadString();
			Description = from.ReadString();
			if (HasPhoto) Photo = TLFactory.Read<TLInputWebDocument>(from);
			Invoice = TLFactory.Read<TLInvoice>(from);
			Payload = from.ReadByteArray();
			Provider = from.ReadString();
			ProviderData = TLFactory.Read<TLDataJSON>(from);
			StartParam = from.ReadString();
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteString(Title ?? string.Empty);
			to.WriteString(Description ?? string.Empty);
			if (HasPhoto) to.WriteObject(Photo);
			to.WriteObject(Invoice);
			to.WriteByteArray(Payload);
			to.WriteString(Provider ?? string.Empty);
			to.WriteObject(ProviderData);
			to.WriteString(StartParam ?? string.Empty);
		}

		private void UpdateFlags()
		{
			HasPhoto = Photo != null;
		}
	}
}