// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLInputMediaUploadedDocument : TLInputMediaBase, ITLMessageMediaCaption 
	{
		[Flags]
		public enum Flag : Int32
		{
			NoSoundVideo = (1 << 3),
			Thumb = (1 << 2),
			Stickers = (1 << 0),
			TTLSeconds = (1 << 1),
		}

		public bool IsNoSoundVideo { get { return Flags.HasFlag(Flag.NoSoundVideo); } set { Flags = value ? (Flags | Flag.NoSoundVideo) : (Flags & ~Flag.NoSoundVideo); } }
		public bool HasThumb { get { return Flags.HasFlag(Flag.Thumb); } set { Flags = value ? (Flags | Flag.Thumb) : (Flags & ~Flag.Thumb); } }
		public bool HasStickers { get { return Flags.HasFlag(Flag.Stickers); } set { Flags = value ? (Flags | Flag.Stickers) : (Flags & ~Flag.Stickers); } }
		public bool HasTTLSeconds { get { return Flags.HasFlag(Flag.TTLSeconds); } set { Flags = value ? (Flags | Flag.TTLSeconds) : (Flags & ~Flag.TTLSeconds); } }

		public Flag Flags { get; set; }
		public TLInputFileBase File { get; set; }
		public TLInputFileBase Thumb { get; set; }
		public String MimeType { get; set; }
		public TLVector<TLDocumentAttributeBase> Attributes { get; set; }
		public String Caption { get; set; }
		public TLVector<TLInputDocumentBase> Stickers { get; set; }
		public Int32? TTLSeconds { get; set; }

		public TLInputMediaUploadedDocument() { }
		public TLInputMediaUploadedDocument(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.InputMediaUploadedDocument; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			File = TLFactory.Read<TLInputFileBase>(from);
			if (HasThumb) Thumb = TLFactory.Read<TLInputFileBase>(from);
			MimeType = from.ReadString();
			Attributes = TLFactory.Read<TLVector<TLDocumentAttributeBase>>(from);
			Caption = from.ReadString();
			if (HasStickers) Stickers = TLFactory.Read<TLVector<TLInputDocumentBase>>(from);
			if (HasTTLSeconds) TTLSeconds = from.ReadInt32();
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteObject(File);
			if (HasThumb) to.WriteObject(Thumb);
			to.WriteString(MimeType ?? string.Empty);
			to.WriteObject(Attributes);
			to.WriteString(Caption ?? string.Empty);
			if (HasStickers) to.WriteObject(Stickers);
			if (HasTTLSeconds) to.WriteInt32(TTLSeconds.Value);
		}

		private void UpdateFlags()
		{
			HasThumb = Thumb != null;
			HasStickers = Stickers != null;
			HasTTLSeconds = TTLSeconds != null;
		}
	}
}