// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLMessage : TLMessageCommonBase 
	{
		[Flags]
		public enum Flag : Int32
		{
			Out = (1 << 1),
			Mentioned = (1 << 4),
			MediaUnread = (1 << 5),
			Silent = (1 << 13),
			Post = (1 << 14),
			FromId = (1 << 8),
			FwdFrom = (1 << 2),
			ViaBotId = (1 << 11),
			ReplyToMsgId = (1 << 3),
			Media = (1 << 9),
			ReplyMarkup = (1 << 6),
			Entities = (1 << 7),
			Views = (1 << 10),
			EditDate = (1 << 15),
			PostAuthor = (1 << 16),
			GroupedId = (1 << 17),
		}

		public override bool IsOut { get { return Flags.HasFlag(Flag.Out); } set { Flags = value ? (Flags | Flag.Out) : (Flags & ~Flag.Out); } }
		public override bool IsMentioned { get { return Flags.HasFlag(Flag.Mentioned); } set { Flags = value ? (Flags | Flag.Mentioned) : (Flags & ~Flag.Mentioned); } }
		public override bool IsMediaUnread { get { return Flags.HasFlag(Flag.MediaUnread); } set { Flags = value ? (Flags | Flag.MediaUnread) : (Flags & ~Flag.MediaUnread); } }
		public override bool IsSilent { get { return Flags.HasFlag(Flag.Silent); } set { Flags = value ? (Flags | Flag.Silent) : (Flags & ~Flag.Silent); } }
		public override bool IsPost { get { return Flags.HasFlag(Flag.Post); } set { Flags = value ? (Flags | Flag.Post) : (Flags & ~Flag.Post); } }
		public bool HasFromId { get { return Flags.HasFlag(Flag.FromId); } set { Flags = value ? (Flags | Flag.FromId) : (Flags & ~Flag.FromId); } }
		public bool HasFwdFrom { get { return Flags.HasFlag(Flag.FwdFrom); } set { Flags = value ? (Flags | Flag.FwdFrom) : (Flags & ~Flag.FwdFrom); } }
		public bool HasViaBotId { get { return Flags.HasFlag(Flag.ViaBotId); } set { Flags = value ? (Flags | Flag.ViaBotId) : (Flags & ~Flag.ViaBotId); } }
		public bool HasReplyToMsgId { get { return Flags.HasFlag(Flag.ReplyToMsgId); } set { Flags = value ? (Flags | Flag.ReplyToMsgId) : (Flags & ~Flag.ReplyToMsgId); } }
		public bool HasMedia { get { return Flags.HasFlag(Flag.Media); } set { Flags = value ? (Flags | Flag.Media) : (Flags & ~Flag.Media); } }
		public bool HasReplyMarkup { get { return Flags.HasFlag(Flag.ReplyMarkup); } set { Flags = value ? (Flags | Flag.ReplyMarkup) : (Flags & ~Flag.ReplyMarkup); } }
		public bool HasEntities { get { return Flags.HasFlag(Flag.Entities); } set { Flags = value ? (Flags | Flag.Entities) : (Flags & ~Flag.Entities); } }
		public bool HasViews { get { return Flags.HasFlag(Flag.Views); } set { Flags = value ? (Flags | Flag.Views) : (Flags & ~Flag.Views); } }
		public bool HasEditDate { get { return Flags.HasFlag(Flag.EditDate); } set { Flags = value ? (Flags | Flag.EditDate) : (Flags & ~Flag.EditDate); } }
		public bool HasPostAuthor { get { return Flags.HasFlag(Flag.PostAuthor); } set { Flags = value ? (Flags | Flag.PostAuthor) : (Flags & ~Flag.PostAuthor); } }
		public bool HasGroupedId { get { return Flags.HasFlag(Flag.GroupedId); } set { Flags = value ? (Flags | Flag.GroupedId) : (Flags & ~Flag.GroupedId); } }

		public Flag Flags { get; set; }
		public TLMessageFwdHeader FwdFrom { get; set; }
		public Int32? ViaBotId { get; set; }
		public String Message { get; set; }
		public TLMessageMediaBase Media { get; set; }
		public TLReplyMarkupBase ReplyMarkup { get; set; }
		public TLVector<TLMessageEntityBase> Entities { get; set; }
		public Int32? Views { get; set; }
		public Int32? EditDate { get; set; }
		public String PostAuthor { get; set; }
		public Int64? GroupedId { get; set; }

		public TLMessage() { }
		public TLMessage(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.Message; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Id = from.ReadInt32();
			if (HasFromId) FromId = from.ReadInt32();
			ToId = TLFactory.Read<TLPeerBase>(from);
			if (HasFwdFrom) FwdFrom = TLFactory.Read<TLMessageFwdHeader>(from);
			if (HasViaBotId) ViaBotId = from.ReadInt32();
			if (HasReplyToMsgId) ReplyToMsgId = from.ReadInt32();
			Date = from.ReadInt32();
			Message = from.ReadString();
			if (HasMedia) Media = TLFactory.Read<TLMessageMediaBase>(from);
			if (HasReplyMarkup) ReplyMarkup = TLFactory.Read<TLReplyMarkupBase>(from);
			if (HasEntities) Entities = TLFactory.Read<TLVector<TLMessageEntityBase>>(from);
			if (HasViews) Views = from.ReadInt32();
			if (HasEditDate) EditDate = from.ReadInt32();
			if (HasPostAuthor) PostAuthor = from.ReadString();
			if (HasGroupedId) GroupedId = from.ReadInt64();
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteInt32(Id);
			if (HasFromId) to.WriteInt32(FromId.Value);
			to.WriteObject(ToId);
			if (HasFwdFrom) to.WriteObject(FwdFrom);
			if (HasViaBotId) to.WriteInt32(ViaBotId.Value);
			if (HasReplyToMsgId) to.WriteInt32(ReplyToMsgId.Value);
			to.WriteInt32(Date);
			to.WriteString(Message ?? string.Empty);
			if (HasMedia) to.WriteObject(Media);
			if (HasReplyMarkup) to.WriteObject(ReplyMarkup);
			if (HasEntities) to.WriteObject(Entities);
			if (HasViews) to.WriteInt32(Views.Value);
			if (HasEditDate) to.WriteInt32(EditDate.Value);
			if (HasPostAuthor) to.WriteString(PostAuthor ?? string.Empty);
			if (HasGroupedId) to.WriteInt64(GroupedId.Value);
		}

		private void UpdateFlags()
		{
			HasFromId = FromId != null;
			HasFwdFrom = FwdFrom != null;
			HasViaBotId = ViaBotId != null;
			HasReplyToMsgId = ReplyToMsgId != null;
			HasMedia = Media != null;
			HasReplyMarkup = ReplyMarkup != null;
			HasEntities = Entities != null;
			HasViews = Views != null;
			HasEditDate = EditDate != null;
			HasPostAuthor = PostAuthor != null;
			HasGroupedId = GroupedId != null;
		}
	}
}