// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLMessageFwdHeader : TLObject 
	{
		[Flags]
		public enum Flag : Int32
		{
			FromId = (1 << 0),
			ChannelId = (1 << 1),
			ChannelPost = (1 << 2),
			PostAuthor = (1 << 3),
			SavedFromPeer = (1 << 4),
			SavedFromMsgId = (1 << 4),
		}

		public bool HasFromId { get { return Flags.HasFlag(Flag.FromId); } set { Flags = value ? (Flags | Flag.FromId) : (Flags & ~Flag.FromId); } }
		public bool HasChannelId { get { return Flags.HasFlag(Flag.ChannelId); } set { Flags = value ? (Flags | Flag.ChannelId) : (Flags & ~Flag.ChannelId); } }
		public bool HasChannelPost { get { return Flags.HasFlag(Flag.ChannelPost); } set { Flags = value ? (Flags | Flag.ChannelPost) : (Flags & ~Flag.ChannelPost); } }
		public bool HasPostAuthor { get { return Flags.HasFlag(Flag.PostAuthor); } set { Flags = value ? (Flags | Flag.PostAuthor) : (Flags & ~Flag.PostAuthor); } }
		public bool HasSavedFromPeer { get { return Flags.HasFlag(Flag.SavedFromPeer); } set { Flags = value ? (Flags | Flag.SavedFromPeer) : (Flags & ~Flag.SavedFromPeer); } }
		public bool HasSavedFromMsgId { get { return Flags.HasFlag(Flag.SavedFromMsgId); } set { Flags = value ? (Flags | Flag.SavedFromMsgId) : (Flags & ~Flag.SavedFromMsgId); } }

		public Flag Flags { get; set; }
		public Int32? FromId { get; set; }
		public Int32 Date { get; set; }
		public Int32? ChannelId { get; set; }
		public Int32? ChannelPost { get; set; }
		public String PostAuthor { get; set; }
		public TLPeerBase SavedFromPeer { get; set; }
		public Int32? SavedFromMsgId { get; set; }

		public TLMessageFwdHeader() { }
		public TLMessageFwdHeader(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.MessageFwdHeader; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			if (HasFromId) FromId = from.ReadInt32();
			Date = from.ReadInt32();
			if (HasChannelId) ChannelId = from.ReadInt32();
			if (HasChannelPost) ChannelPost = from.ReadInt32();
			if (HasPostAuthor) PostAuthor = from.ReadString();
			if (HasSavedFromPeer) SavedFromPeer = TLFactory.Read<TLPeerBase>(from);
			if (HasSavedFromMsgId) SavedFromMsgId = from.ReadInt32();
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			if (HasFromId) to.WriteInt32(FromId.Value);
			to.WriteInt32(Date);
			if (HasChannelId) to.WriteInt32(ChannelId.Value);
			if (HasChannelPost) to.WriteInt32(ChannelPost.Value);
			if (HasPostAuthor) to.WriteString(PostAuthor ?? string.Empty);
			if (HasSavedFromPeer) to.WriteObject(SavedFromPeer);
			if (HasSavedFromMsgId) to.WriteInt32(SavedFromMsgId.Value);
		}

		private void UpdateFlags()
		{
			HasFromId = FromId != null;
			HasChannelId = ChannelId != null;
			HasChannelPost = ChannelPost != null;
			HasPostAuthor = PostAuthor != null;
			HasSavedFromPeer = SavedFromPeer != null;
			HasSavedFromMsgId = SavedFromMsgId != null;
		}
	}
}