// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLMessageMediaDocument : TLMessageMediaBase 
	{
		[Flags]
		public enum Flag : Int32
		{
			Document = (1 << 0),
			Caption = (1 << 1),
			TTLSeconds = (1 << 2),
		}

		public bool HasDocument { get { return Flags.HasFlag(Flag.Document); } set { Flags = value ? (Flags | Flag.Document) : (Flags & ~Flag.Document); } }
		public bool HasCaption { get { return Flags.HasFlag(Flag.Caption); } set { Flags = value ? (Flags | Flag.Caption) : (Flags & ~Flag.Caption); } }
		public bool HasTTLSeconds { get { return Flags.HasFlag(Flag.TTLSeconds); } set { Flags = value ? (Flags | Flag.TTLSeconds) : (Flags & ~Flag.TTLSeconds); } }

		public Flag Flags { get; set; }
		public TLDocumentBase Document { get; set; }
		public String Caption { get; set; }
		public Int32? TTLSeconds { get; set; }

		public TLMessageMediaDocument() { }
		public TLMessageMediaDocument(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.MessageMediaDocument; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			if (HasDocument) Document = TLFactory.Read<TLDocumentBase>(from);
			if (HasCaption) Caption = from.ReadString();
			if (HasTTLSeconds) TTLSeconds = from.ReadInt32();
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			if (HasDocument) to.WriteObject(Document);
			if (HasCaption) to.WriteString(Caption ?? string.Empty);
			if (HasTTLSeconds) to.WriteInt32(TTLSeconds.Value);
		}

		private void UpdateFlags()
		{
			HasDocument = Document != null;
			HasCaption = Caption != null;
			HasTTLSeconds = TTLSeconds != null;
		}
	}
}