// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLMessageService : TLMessageCommonBase 
	{
		[Flags]
		public enum Flag : Int32
		{
			Out = (1 << 1),
			Mentioned = (1 << 4),
			MediaUnread = (1 << 5),
			Silent = (1 << 13),
			Post = (1 << 14),
			FromId = (1 << 8),
			ReplyToMsgId = (1 << 3),
		}

		public override bool IsOut { get { return Flags.HasFlag(Flag.Out); } set { Flags = value ? (Flags | Flag.Out) : (Flags & ~Flag.Out); } }
		public override bool IsMentioned { get { return Flags.HasFlag(Flag.Mentioned); } set { Flags = value ? (Flags | Flag.Mentioned) : (Flags & ~Flag.Mentioned); } }
		public override bool IsMediaUnread { get { return Flags.HasFlag(Flag.MediaUnread); } set { Flags = value ? (Flags | Flag.MediaUnread) : (Flags & ~Flag.MediaUnread); } }
		public override bool IsSilent { get { return Flags.HasFlag(Flag.Silent); } set { Flags = value ? (Flags | Flag.Silent) : (Flags & ~Flag.Silent); } }
		public override bool IsPost { get { return Flags.HasFlag(Flag.Post); } set { Flags = value ? (Flags | Flag.Post) : (Flags & ~Flag.Post); } }
		public bool HasFromId { get { return Flags.HasFlag(Flag.FromId); } set { Flags = value ? (Flags | Flag.FromId) : (Flags & ~Flag.FromId); } }
		public bool HasReplyToMsgId { get { return Flags.HasFlag(Flag.ReplyToMsgId); } set { Flags = value ? (Flags | Flag.ReplyToMsgId) : (Flags & ~Flag.ReplyToMsgId); } }

		public Flag Flags { get; set; }
		public TLMessageActionBase Action { get; set; }

		public TLMessageService() { }
		public TLMessageService(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.MessageService; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Id = from.ReadInt32();
			if (HasFromId) FromId = from.ReadInt32();
			ToId = TLFactory.Read<TLPeerBase>(from);
			if (HasReplyToMsgId) ReplyToMsgId = from.ReadInt32();
			Date = from.ReadInt32();
			Action = TLFactory.Read<TLMessageActionBase>(from);
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteInt32(Id);
			if (HasFromId) to.WriteInt32(FromId.Value);
			to.WriteObject(ToId);
			if (HasReplyToMsgId) to.WriteInt32(ReplyToMsgId.Value);
			to.WriteInt32(Date);
			to.WriteObject(Action);
		}

		private void UpdateFlags()
		{
			HasFromId = FromId != null;
			HasReplyToMsgId = ReplyToMsgId != null;
		}
	}
}