// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLPageBlockEmbed : TLPageBlockBase 
	{
		[Flags]
		public enum Flag : Int32
		{
			FullWidth = (1 << 0),
			AllowScrolling = (1 << 3),
			Url = (1 << 1),
			Html = (1 << 2),
			PosterPhotoId = (1 << 4),
		}

		public bool IsFullWidth { get { return Flags.HasFlag(Flag.FullWidth); } set { Flags = value ? (Flags | Flag.FullWidth) : (Flags & ~Flag.FullWidth); } }
		public bool IsAllowScrolling { get { return Flags.HasFlag(Flag.AllowScrolling); } set { Flags = value ? (Flags | Flag.AllowScrolling) : (Flags & ~Flag.AllowScrolling); } }
		public bool HasUrl { get { return Flags.HasFlag(Flag.Url); } set { Flags = value ? (Flags | Flag.Url) : (Flags & ~Flag.Url); } }
		public bool HasHtml { get { return Flags.HasFlag(Flag.Html); } set { Flags = value ? (Flags | Flag.Html) : (Flags & ~Flag.Html); } }
		public bool HasPosterPhotoId { get { return Flags.HasFlag(Flag.PosterPhotoId); } set { Flags = value ? (Flags | Flag.PosterPhotoId) : (Flags & ~Flag.PosterPhotoId); } }

		public Flag Flags { get; set; }
		public String Url { get; set; }
		public String Html { get; set; }
		public Int64? PosterPhotoId { get; set; }
		public Int32 W { get; set; }
		public Int32 H { get; set; }
		public TLRichTextBase Caption { get; set; }

		public TLPageBlockEmbed() { }
		public TLPageBlockEmbed(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.PageBlockEmbed; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			if (HasUrl) Url = from.ReadString();
			if (HasHtml) Html = from.ReadString();
			if (HasPosterPhotoId) PosterPhotoId = from.ReadInt64();
			W = from.ReadInt32();
			H = from.ReadInt32();
			Caption = TLFactory.Read<TLRichTextBase>(from);
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			if (HasUrl) to.WriteString(Url ?? string.Empty);
			if (HasHtml) to.WriteString(Html ?? string.Empty);
			if (HasPosterPhotoId) to.WriteInt64(PosterPhotoId.Value);
			to.WriteInt32(W);
			to.WriteInt32(H);
			to.WriteObject(Caption);
		}

		private void UpdateFlags()
		{
			HasUrl = Url != null;
			HasHtml = Html != null;
			HasPosterPhotoId = PosterPhotoId != null;
		}
	}
}