// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLPaymentRequestedInfo : TLObject 
	{
		[Flags]
		public enum Flag : Int32
		{
			Name = (1 << 0),
			Phone = (1 << 1),
			Email = (1 << 2),
			ShippingAddress = (1 << 3),
		}

		public bool HasName { get { return Flags.HasFlag(Flag.Name); } set { Flags = value ? (Flags | Flag.Name) : (Flags & ~Flag.Name); } }
		public bool HasPhone { get { return Flags.HasFlag(Flag.Phone); } set { Flags = value ? (Flags | Flag.Phone) : (Flags & ~Flag.Phone); } }
		public bool HasEmail { get { return Flags.HasFlag(Flag.Email); } set { Flags = value ? (Flags | Flag.Email) : (Flags & ~Flag.Email); } }
		public bool HasShippingAddress { get { return Flags.HasFlag(Flag.ShippingAddress); } set { Flags = value ? (Flags | Flag.ShippingAddress) : (Flags & ~Flag.ShippingAddress); } }

		public Flag Flags { get; set; }
		public String Name { get; set; }
		public String Phone { get; set; }
		public String Email { get; set; }
		public TLPostAddress ShippingAddress { get; set; }

		public TLPaymentRequestedInfo() { }
		public TLPaymentRequestedInfo(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.PaymentRequestedInfo; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			if (HasName) Name = from.ReadString();
			if (HasPhone) Phone = from.ReadString();
			if (HasEmail) Email = from.ReadString();
			if (HasShippingAddress) ShippingAddress = TLFactory.Read<TLPostAddress>(from);
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			if (HasName) to.WriteString(Name ?? string.Empty);
			if (HasPhone) to.WriteString(Phone ?? string.Empty);
			if (HasEmail) to.WriteString(Email ?? string.Empty);
			if (HasShippingAddress) to.WriteObject(ShippingAddress);
		}

		private void UpdateFlags()
		{
			HasName = Name != null;
			HasPhone = Phone != null;
			HasEmail = Email != null;
			HasShippingAddress = ShippingAddress != null;
		}
	}
}