// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLStickerSet : TLObject 
	{
		[Flags]
		public enum Flag : Int32
		{
			Installed = (1 << 0),
			Archived = (1 << 1),
			Official = (1 << 2),
			Masks = (1 << 3),
		}

		public bool IsInstalled { get { return Flags.HasFlag(Flag.Installed); } set { Flags = value ? (Flags | Flag.Installed) : (Flags & ~Flag.Installed); } }
		public bool IsArchived { get { return Flags.HasFlag(Flag.Archived); } set { Flags = value ? (Flags | Flag.Archived) : (Flags & ~Flag.Archived); } }
		public bool IsOfficial { get { return Flags.HasFlag(Flag.Official); } set { Flags = value ? (Flags | Flag.Official) : (Flags & ~Flag.Official); } }
		public bool IsMasks { get { return Flags.HasFlag(Flag.Masks); } set { Flags = value ? (Flags | Flag.Masks) : (Flags & ~Flag.Masks); } }

		public Flag Flags { get; set; }
		public Int64 Id { get; set; }
		public Int64 AccessHash { get; set; }
		public String Title { get; set; }
		public String ShortName { get; set; }
		public Int32 Count { get; set; }
		public Int32 Hash { get; set; }

		public TLStickerSet() { }
		public TLStickerSet(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.StickerSet; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			Id = from.ReadInt64();
			AccessHash = from.ReadInt64();
			Title = from.ReadString();
			ShortName = from.ReadString();
			Count = from.ReadInt32();
			Hash = from.ReadInt32();
		}

		public override void Write(TLBinaryWriter to)
		{
			to.WriteInt32((Int32)Flags);
			to.WriteInt64(Id);
			to.WriteInt64(AccessHash);
			to.WriteString(Title ?? string.Empty);
			to.WriteString(ShortName ?? string.Empty);
			to.WriteInt32(Count);
			to.WriteInt32(Hash);
		}
	}
}