// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLUpdateBotCallbackQuery : TLUpdateBase 
	{
		[Flags]
		public enum Flag : Int32
		{
			Data = (1 << 0),
			GameShortName = (1 << 1),
		}

		public bool HasData { get { return Flags.HasFlag(Flag.Data); } set { Flags = value ? (Flags | Flag.Data) : (Flags & ~Flag.Data); } }
		public bool HasGameShortName { get { return Flags.HasFlag(Flag.GameShortName); } set { Flags = value ? (Flags | Flag.GameShortName) : (Flags & ~Flag.GameShortName); } }

		public Flag Flags { get; set; }
		public Int64 QueryId { get; set; }
		public Int32 UserId { get; set; }
		public TLPeerBase Peer { get; set; }
		public Int32 MsgId { get; set; }
		public Int64 ChatInstance { get; set; }
		public Byte[] Data { get; set; }
		public String GameShortName { get; set; }

		public TLUpdateBotCallbackQuery() { }
		public TLUpdateBotCallbackQuery(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.UpdateBotCallbackQuery; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			QueryId = from.ReadInt64();
			UserId = from.ReadInt32();
			Peer = TLFactory.Read<TLPeerBase>(from);
			MsgId = from.ReadInt32();
			ChatInstance = from.ReadInt64();
			if (HasData) Data = from.ReadByteArray();
			if (HasGameShortName) GameShortName = from.ReadString();
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteInt64(QueryId);
			to.WriteInt32(UserId);
			to.WriteObject(Peer);
			to.WriteInt32(MsgId);
			to.WriteInt64(ChatInstance);
			if (HasData) to.WriteByteArray(Data);
			if (HasGameShortName) to.WriteString(GameShortName ?? string.Empty);
		}

		private void UpdateFlags()
		{
			HasData = Data != null;
			HasGameShortName = GameShortName != null;
		}
	}
}