// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLUpdateBotPrecheckoutQuery : TLUpdateBase 
	{
		[Flags]
		public enum Flag : Int32
		{
			Info = (1 << 0),
			ShippingOptionId = (1 << 1),
		}

		public bool HasInfo { get { return Flags.HasFlag(Flag.Info); } set { Flags = value ? (Flags | Flag.Info) : (Flags & ~Flag.Info); } }
		public bool HasShippingOptionId { get { return Flags.HasFlag(Flag.ShippingOptionId); } set { Flags = value ? (Flags | Flag.ShippingOptionId) : (Flags & ~Flag.ShippingOptionId); } }

		public Flag Flags { get; set; }
		public Int64 QueryId { get; set; }
		public Int32 UserId { get; set; }
		public Byte[] Payload { get; set; }
		public TLPaymentRequestedInfo Info { get; set; }
		public String ShippingOptionId { get; set; }
		public String Currency { get; set; }
		public Int64 TotalAmount { get; set; }

		public TLUpdateBotPrecheckoutQuery() { }
		public TLUpdateBotPrecheckoutQuery(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.UpdateBotPrecheckoutQuery; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			QueryId = from.ReadInt64();
			UserId = from.ReadInt32();
			Payload = from.ReadByteArray();
			if (HasInfo) Info = TLFactory.Read<TLPaymentRequestedInfo>(from);
			if (HasShippingOptionId) ShippingOptionId = from.ReadString();
			Currency = from.ReadString();
			TotalAmount = from.ReadInt64();
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteInt64(QueryId);
			to.WriteInt32(UserId);
			to.WriteByteArray(Payload);
			if (HasInfo) to.WriteObject(Info);
			if (HasShippingOptionId) to.WriteString(ShippingOptionId ?? string.Empty);
			to.WriteString(Currency ?? string.Empty);
			to.WriteInt64(TotalAmount);
		}

		private void UpdateFlags()
		{
			HasInfo = Info != null;
			HasShippingOptionId = ShippingOptionId != null;
		}
	}
}