// <auto-generated/>
using System;
using Telegram.Api.Native.TL;

namespace Telegram.Api.TL
{
	public partial class TLUpdateServiceNotification : TLUpdateBase 
	{
		[Flags]
		public enum Flag : Int32
		{
			Popup = (1 << 0),
			InboxDate = (1 << 1),
		}

		public bool IsPopup { get { return Flags.HasFlag(Flag.Popup); } set { Flags = value ? (Flags | Flag.Popup) : (Flags & ~Flag.Popup); } }
		public bool HasInboxDate { get { return Flags.HasFlag(Flag.InboxDate); } set { Flags = value ? (Flags | Flag.InboxDate) : (Flags & ~Flag.InboxDate); } }

		public Flag Flags { get; set; }
		public Int32? InboxDate { get; set; }
		public String Type { get; set; }
		public String Message { get; set; }
		public TLMessageMediaBase Media { get; set; }
		public TLVector<TLMessageEntityBase> Entities { get; set; }

		public TLUpdateServiceNotification() { }
		public TLUpdateServiceNotification(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.UpdateServiceNotification; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			if (HasInboxDate) InboxDate = from.ReadInt32();
			Type = from.ReadString();
			Message = from.ReadString();
			Media = TLFactory.Read<TLMessageMediaBase>(from);
			Entities = TLFactory.Read<TLVector<TLMessageEntityBase>>(from);
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			if (HasInboxDate) to.WriteInt32(InboxDate.Value);
			to.WriteString(Type ?? string.Empty);
			to.WriteString(Message ?? string.Empty);
			to.WriteObject(Media);
			to.WriteObject(Entities);
		}

		private void UpdateFlags()
		{
			HasInboxDate = InboxDate != null;
		}
	}
}