// <auto-generated/>
using System;
using Telegram.Api.Native.TL;
using Telegram.Api.TL.Contacts;

namespace Telegram.Api.TL
{
	public partial class TLUserFull : TLObject 
	{
		[Flags]
		public enum Flag : Int32
		{
			Blocked = (1 << 0),
			PhoneCallsAvailable = (1 << 4),
			PhoneCallsPrivate = (1 << 5),
			About = (1 << 1),
			ProfilePhoto = (1 << 2),
			BotInfo = (1 << 3),
		}

		public bool IsBlocked { get { return Flags.HasFlag(Flag.Blocked); } set { Flags = value ? (Flags | Flag.Blocked) : (Flags & ~Flag.Blocked); } }
		public bool IsPhoneCallsAvailable { get { return Flags.HasFlag(Flag.PhoneCallsAvailable); } set { Flags = value ? (Flags | Flag.PhoneCallsAvailable) : (Flags & ~Flag.PhoneCallsAvailable); } }
		public bool IsPhoneCallsPrivate { get { return Flags.HasFlag(Flag.PhoneCallsPrivate); } set { Flags = value ? (Flags | Flag.PhoneCallsPrivate) : (Flags & ~Flag.PhoneCallsPrivate); } }
		public bool HasAbout { get { return Flags.HasFlag(Flag.About); } set { Flags = value ? (Flags | Flag.About) : (Flags & ~Flag.About); } }
		public bool HasProfilePhoto { get { return Flags.HasFlag(Flag.ProfilePhoto); } set { Flags = value ? (Flags | Flag.ProfilePhoto) : (Flags & ~Flag.ProfilePhoto); } }
		public bool HasBotInfo { get { return Flags.HasFlag(Flag.BotInfo); } set { Flags = value ? (Flags | Flag.BotInfo) : (Flags & ~Flag.BotInfo); } }

		public Flag Flags { get; set; }
		public TLUserBase User { get; set; }
		public String About { get; set; }
		public TLContactsLink Link { get; set; }
		public TLPhotoBase ProfilePhoto { get; set; }
		public TLPeerNotifySettingsBase NotifySettings { get; set; }
		public TLBotInfo BotInfo { get; set; }
		public Int32 CommonChatsCount { get; set; }

		public TLUserFull() { }
		public TLUserFull(TLBinaryReader from)
		{
			Read(from);
		}

		public override TLType TypeId { get { return TLType.UserFull; } }

		public override void Read(TLBinaryReader from)
		{
			Flags = (Flag)from.ReadInt32();
			User = TLFactory.Read<TLUserBase>(from);
			if (HasAbout) About = from.ReadString();
			Link = TLFactory.Read<TLContactsLink>(from);
			if (HasProfilePhoto) ProfilePhoto = TLFactory.Read<TLPhotoBase>(from);
			NotifySettings = TLFactory.Read<TLPeerNotifySettingsBase>(from);
			if (HasBotInfo) BotInfo = TLFactory.Read<TLBotInfo>(from);
			CommonChatsCount = from.ReadInt32();
		}

		public override void Write(TLBinaryWriter to)
		{
			UpdateFlags();

			to.WriteInt32((Int32)Flags);
			to.WriteObject(User);
			if (HasAbout) to.WriteString(About ?? string.Empty);
			to.WriteObject(Link);
			if (HasProfilePhoto) to.WriteObject(ProfilePhoto);
			to.WriteObject(NotifySettings);
			if (HasBotInfo) to.WriteObject(BotInfo);
			to.WriteInt32(CommonChatsCount);
		}

		private void UpdateFlags()
		{
			HasAbout = About != null;
			HasProfilePhoto = ProfilePhoto != null;
			HasBotInfo = BotInfo != null;
		}
	}
}