﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices.WindowsRuntime;
using Telegram.Api.TL;
using Unigram.Controls.Views;
using Unigram.Views;
using Unigram.ViewModels.Settings;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using Telegram.Api.TL.Messages;

namespace Unigram.Views.Settings
{
    public sealed partial class SettingsStickersArchivedPage : Page
    {
        public SettingsStickersArchivedViewModel ViewModel => DataContext as SettingsStickersArchivedViewModel;

        public SettingsStickersArchivedPage()
        {
            InitializeComponent();
            DataContext = UnigramContainer.Current.ResolveType<SettingsStickersArchivedViewModel>();
        }

        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
            while (Frame.BackStackDepth > 2)
            {
                Frame.BackStack.RemoveAt(2);
            }
        }

        private async void ListView_ItemClick(object sender, ItemClickEventArgs e)
        {
            if (e.ClickedItem is TLMessagesStickerSet stickerSet)
            {
                // WARNING: we are using TLMessagesStickerSet only because we already expanded it to supply "Cover" property.
                // but this IS NOT a full sticker set.
                await StickerSetView.Current.ShowAsync(new TLInputStickerSetID { Id = stickerSet.Set.Id, AccessHash = stickerSet.Set.AccessHash });
            }
        }
    }
}
