import { map } from "@funkia/hareactive";
import { runComponent, elements, go } from "../../src";
const { span, input, div } = elements;

const isValidEmail = (s: string) => s.match(/.+@.+\..+/i);

const main = go(function* () {
  yield span("Please enter an email address: ");
  const { inputValue: email } = yield input();
  const isValid = map(isValidEmail, email);
  yield div([
    "The address is ", map((b) => b ? "valid" : "invalid", isValid)
  ]);
});

// `runComponent` should be the only impure function in application code
runComponent("#mount", main);
