---
title: How To Guides
layout: documentation
after: /bundle/
---
# How To Guides

This section includes How To documentation for performing common WiX tasks.

## Files, Shortcuts and Registry

* [Add a file to your installer](files_and_registry/add_a_file.md)
* [Check the version number of a file during installation](files_and_registry/check_the_version_number.md)
* [Write a registry entry during installation](files_and_registry/write_a_registry_entry.md)
* [Read a registry entry during installation](files_and_registry/read_a_registry_entry.md)
* [Create a shortcut on the Start Menu](files_and_registry/create_start_menu_shortcut.md)
* [Create a shortcut to a web page](files_and_registry/create_internet_shortcut.md)
* [Create an uninstall shortcut](files_and_registry/create_uninstall_shortcut.md)
* [NGen managed assemblies during installation](files_and_registry/ngen_managed_assemblies.md)
* [Reference another DirectorySearch element](files_and_registry/directorysearchref.md)
* [Get the parent directory of a file search](files_and_registry/parentdirectorysearch.md)

## Redistributables and Install Checks

* [Check for .NET Framework versions](redistributables_and_install_checks/check_for_dotnet.md)
* [Install the .NET Framework using a bootstrapper](redistributables_and_install_checks/install_dotnet.md)
* [Install DirectX 9.0 with your installer](redistributables_and_install_checks/install_directx9.md)
* [Install the Visual C++ Redistributable with your installer](redistributables_and_install_checks/install_vcredist.md)
* [Block installation based on OS version](redistributables_and_install_checks/block_install_on_os.md)

## User Interface and Localization

* [Build a localized version of your installer](ui_and_localization/build_a_localized_version.md)
* [Make your installer localizable](ui_and_localization/make_installer_localizable.md)
* [Run the installed application after setup](ui_and_localization/run_program_after_install.md)
* [Set your installer&apos;s icon in Add/Remove Programs](ui_and_localization/configure_arp_appearance.md)

## Product Updates

* [Implement a major upgrade in your installer](updates/major_upgrade.md)

## Others

* [Get a log of your installation for debugging](general/get_a_log.md)
* [Look inside your MSI with Orca](general/look_inside_msi.md)
* [Generate a GUID](general/generate_guids.md)
* [Use WiX Extensions](general/extension_usage_introduction.md)
* [Optimize building cabinet files](general/optimizing_builds.md)
* [Specify source file locations](general/specifying_source_files.md)
* [Install a windows service](general/install_windows_service.md)
