---
title: Getting Started Learning WiX
layout: documentation
---
# Getting Started

There are several options available to get started learning how to use WiX.

## How To Guides

This help file includes a set of [How To Guides](../howtos/index.md) that explain how to accomplish common Windows Installer tasks using WiX.

## Tutorials

* <a href="https://www.firegiant.com/wix/tutorial/" target="_blank">WiX Tutorial</a>
* <a href="http://channel9.msdn.com/Blogs/scobleizer/Wix-team-The-most-used-piece-of-software-at-Microsoft-and-its-open-source" target="_blank">Video on Channel 9</a>

## Community

If you prefer to learn by interacting with the community, there is a <a href="/docs/gethelp/#wixusers" target="_blank">WiX users mailing list</a>.

## Integrated Development Environment

If you prefer to learn by using an integrated development environment, there is 
an overview of WiX editors at
<a href="http://robmensching.com/blog/posts/2007/11/20/wix-editors" target="_blank">http://robmensching.com/blog/posts/2007/11/20/wix-editors</a>.

## Reverse Engineering

If you prefer to learn by working backward from a Windows Installer package you have already created, you can run the [WiX decompiler](../overview/alltools.md) \(Dark\) to convert your package into WiX authoring and then recompile it using the [WiX compiler](../overview/candle.md) \(Candle\) and [WiX linker](../overview/light.md) \(Light\).

## Reading Source Code

If you prefer to learn by reading code, WiX is an open source project, and you can look at the source code by reviewing the [How to be a WiX Developer](../wixdev/index.md) topic.

## Fix a Bug, Write a Feature

If you prefer to learn by writing code, you can review the <a href="http://wixtoolset.org/bugs/" target="_blank">WiX issue tracker</a>.

For WiX development assistance, there is a <a href="/docs/gethelp/#wixdevs" target="_blank">WiX developer mailing list</a>.
 