---
title: Registry Element
layout: documentation_xsd_main
---
<dl>
  <dt>Description</dt>
  <dd>This element has been deprecated; please use the <a href="../registryvalue/">RegistryValue</a> element instead.</dd>
  <dt>Windows Installer references</dt>
  <dd>
    <a href="http://msdn.microsoft.com/library/aa371168.aspx" target="_blank">Registry Table</a>
  </dd>
  <dt>Parents</dt>
  <dd>
    <a href="../component/">Component</a>, <a href="../registry/">Registry</a></dd>
  <dt>Inner Text</dt>
  <dd>None</dd>
  <dt>Children</dt>
  <dd>Choice of elements (min: 0, max: unbounded)<ul><li><a href="../permission/">Permission</a> (min: 0, max: unbounded)</li><li><a href="../permissionex/">PermissionEx</a> (min: 0, max: unbounded): Can also configure the ACLs for this registry key.</li><li><a href="../registry/">Registry</a> (min: 0, max: unbounded)</li><li><a href="../registryvalue/">RegistryValue</a> (min: 0, max: unbounded)</li><li><span class="extension">Any Element (namespace='##other' processContents='Lax')                              Extensibility point in the WiX XML Schema.  Schema extensions can register additional                             elements at this point in the schema.                         </span><ul><li><a href="../../util/permissionex" class="extension">PermissionEx</a></li></ul></li></ul></dd>
  <dt>Attributes</dt>
  <dd>
    <table cellspacing="0" cellpadding="0" class="schema">
      <tr>
        <th width="15%">Name</th>
        <th width="15%">Type</th>
        <th width="65%">Description</th>
        <th width="15%">Required</th>
      </tr>
      <tr>
        <td>Action</td>
        <td>Enumeration</td>
        <td>                         This is the action that will be taken for this registry key.                       This attribute's value must be one of the following:<dl><dt class="enumerationValue"><dfn>append</dfn></dt><dd>                                     Appends the specified value(s) to a multiString registry key.                                 </dd><dt class="enumerationValue"><dfn>createKey</dfn></dt><dd>                                     Creates the key, if absent, when the parent component is installed.                                 </dd><dt class="enumerationValue"><dfn>createKeyAndRemoveKeyOnUninstall</dfn></dt><dd>                                     Creates the key, if absent, when the parent component is installed then remove the key with all its values and subkeys when the parent component is uninstalled.                                 </dd><dt class="enumerationValue"><dfn>prepend</dfn></dt><dd>                                     Prepends the specified value(s) to a multiString registry key.                                 </dd><dt class="enumerationValue"><dfn>remove</dfn></dt><dd>                                     Removes a registry name when the parent component is installed.                                 </dd><dt class="enumerationValue"><dfn>removeKeyOnInstall</dfn></dt><dd>                                     Removes a key with all its values and subkeys when the parent component is installed.                                 </dd><dt class="enumerationValue"><dfn>removeKeyOnUninstall</dfn></dt><dd>                                     Removes a key with all its values and subkeys when the parent component is uninstalled.                                 </dd><dt class="enumerationValue"><dfn>write</dfn></dt><dd>                                     Writes a registry value.                                 </dd></dl></td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Id</td>
        <td>String</td>
        <td>                     Primary key used to identify this particular entry.  If this attribute is not specified, an identifier will be                     generated by hashing the parent Component identifier, Root, Key, and Name.                 </td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Key</td>
        <td>String</td>
        <td>The localizable key for the registry value.</td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>KeyPath</td>
        <td><a href="../simple_type_yesnotype/">YesNoType</a></td>
        <td>                     Set this attribute to 'yes' to make this registry key the KeyPath of the parent component.  Only one resource (registry,                     file, etc) can be the KeyPath of a component.                 </td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Name</td>
        <td>String</td>
        <td>                     The localizable registry value name.  If this attribute is not provided the default value for the registry key will                     be set instead.  The Windows Installer allows several special values to be set for this attribute.  You should not                     use them in WiX.  Instead use appropriate values in the Action attribute to get the desired behavior.                 </td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Root</td>
        <td><a href="../simple_type_registryroottype/">RegistryRootType</a></td>
        <td>                         The predefined root key for the registry value.                     </td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Type</td>
        <td>Enumeration</td>
        <td>                         Set this attribute to the type of the desired registry key.  This attribute must be specified whenever the Value                         attribute or a child RegistryValue element is specified.    This attribute                         should only be set when the value of the Action attribute does not include the word 'remove'.                       This attribute's value must be one of the following:<dl><dt class="enumerationValue"><dfn>string</dfn></dt><dd>                                     The value is interpreted and stored as a string (REG_SZ).                                 </dd><dt class="enumerationValue"><dfn>integer</dfn></dt><dd>                                     The value is interpreted and stored as an integer (REG_DWORD).                                 </dd><dt class="enumerationValue"><dfn>binary</dfn></dt><dd>                                     The value is interpreted and stored as a hexadecimal value (REG_BINARY).                                 </dd><dt class="enumerationValue"><dfn>expandable</dfn></dt><dd>                                     The value is interpreted and stored as an expandable string (REG_EXPAND_SZ).                                 </dd><dt class="enumerationValue"><dfn>multiString</dfn></dt><dd>                                     The value is interpreted and stored as a multiple strings (REG_MULTI_SZ).                                     Please note that this value will only result in a multi-string value if there is more than one registry value                                     or the Action attribute's value is 'append' or 'prepend'.  Otherwise a string value will be created.                                 </dd></dl></td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Value</td>
        <td>String</td>
        <td>                     Set this attribute to the localizable registry value.  This value is formatted.  The Windows Installer allows                     several special values to be set for this attribute.  You should not use them in WiX.  Instead use appropriate                     values in the Type attribute to get the desired behavior.  This attribute cannot be specified if the Action                     attribute's value contains the word 'remove'.                 </td>
        <td>&nbsp;</td>
      </tr>
    </table>
  </dd>
  <dt>See Also</dt>
  <dd>
    <a href="../">Wix Schema</a>
  </dd>
</dl>
