---
title: RemotePayload Element
layout: documentation_xsd_main
---
<dl>
  <dt>Description</dt>
  <dd>Describes information about a remote file payload that is not available at the time of building the bundle.         The parent must specify DownloadUrl and must not specify SourceFile when using this element.</dd>
  <dt>Windows Installer references</dt>
  <dd>None</dd>
  <dt>Parents</dt>
  <dd>
    <a href="../exepackage/">ExePackage</a>, <a href="../msupackage/">MsuPackage</a></dd>
  <dt>Inner Text</dt>
  <dd>None</dd>
  <dt>Children</dt>
  <dd>None</dd>
  <dt>Attributes</dt>
  <dd>
    <table cellspacing="0" cellpadding="0" class="schema">
      <tr>
        <th width="15%">Name</th>
        <th width="15%">Type</th>
        <th width="65%">Description</th>
        <th width="15%">Required</th>
      </tr>
      <tr>
        <td>CertificatePublicKey</td>
        <td><a href="../simple_type_hextype/">HexType</a></td>
        <td>Public key of the authenticode certificate used to sign the RemotePayload.  Include this attribute if the remote file is signed.</td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>CertificateThumbprint</td>
        <td><a href="../simple_type_hextype/">HexType</a></td>
        <td>Thumbprint of the authenticode certificate used to sign the RemotePayload.  Include this attribute if the remote file is signed.</td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Description</td>
        <td>String</td>
        <td>Description of the file from version resources.</td>
        <td>Yes</td>
      </tr>
      <tr>
        <td>Hash</td>
        <td><a href="../simple_type_hextype/">HexType</a></td>
        <td>SHA-1 hash of the RemotePayload.</td>
        <td>Yes</td>
      </tr>
      <tr>
        <td>ProductName</td>
        <td>String</td>
        <td>Product name of the file from version resouces.</td>
        <td>Yes</td>
      </tr>
      <tr>
        <td>Size</td>
        <td>Integer</td>
        <td>Size of the remote file in bytes.</td>
        <td>Yes</td>
      </tr>
      <tr>
        <td>Version</td>
        <td><a href="../simple_type_versiontype/">VersionType</a></td>
        <td>Version of the remote file</td>
        <td>Yes</td>
      </tr>
    </table>
  </dd>
  <dt>See Also</dt>
  <dd>
    <a href="../">Wix Schema</a>
  </dd>
</dl>
