---
title: RemoveRegistryKey Element
layout: documentation_xsd_main
---
<dl>
  <dt>Description</dt>
  <dd>                 Used for removing registry keys and all child keys either during install or uninstall.             </dd>
  <dt>Windows Installer references</dt>
  <dd>
    <a href="http://msdn.microsoft.com/library/aa371168.aspx" target="_blank">Registry Table</a>, <a href="http://msdn.microsoft.com/library/aa371208.aspx" target="_blank">RemoveRegistry Table</a></dd>
  <dt>Parents</dt>
  <dd>
    <a href="../component/">Component</a>
  </dd>
  <dt>Inner Text</dt>
  <dd>None</dd>
  <dt>Children</dt>
  <dd>None</dd>
  <dt>Attributes</dt>
  <dd>
    <table cellspacing="0" cellpadding="0" class="schema">
      <tr>
        <th width="15%">Name</th>
        <th width="15%">Type</th>
        <th width="65%">Description</th>
        <th width="15%">Required</th>
      </tr>
      <tr>
        <td>Action</td>
        <td>Enumeration</td>
        <td>                         This is the action that will be taken for this registry value.                       This attribute's value must be one of the following:<dl><dt class="enumerationValue"><dfn>removeOnInstall</dfn></dt><dd>                                     Removes a key with all its values and subkeys when the parent component is installed.                                 </dd><dt class="enumerationValue"><dfn>removeOnUninstall</dfn></dt><dd>                                     Removes a key with all its values and subkeys when the parent component is uninstalled.                                 </dd></dl></td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Id</td>
        <td>String</td>
        <td>                         Primary key used to identify this particular entry.  If this attribute is not specified, an identifier will be                         generated by hashing the parent Component identifier, Root, Key, and Name.                     </td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Key</td>
        <td>String</td>
        <td>                         The localizable key for the registry value.                     </td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Root</td>
        <td><a href="../simple_type_registryroottype/">RegistryRootType</a></td>
        <td>                         The predefined root key for the registry value.                     </td>
        <td>&nbsp;</td>
      </tr>
    </table>
  </dd>
  <dt>See Also</dt>
  <dd>
    <a href="../">Wix Schema</a>
  </dd>
</dl>
