---
id: faastjs.awsclientfactory
title: AwsClientFactory interface
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[faastjs](./faastjs.md) &gt; [AwsClientFactory](./faastjs.awsclientfactory.md)

## AwsClientFactory interface

Factory for AWS service clients, which allows for custom construction and configuration. [AWS Configuration](https://docs.aws.amazon.com/AWSJavaScriptSDK/v3/latest/index.html#configuration)<!-- -->.

**Signature:**

```typescript
export interface AwsClientFactory 
```

## Remarks

This is an advanced option. This provides a way for a faast.js client to instantiate AWS service objects for itself to provide custom options. Note that if you create a service object yourself, it won't have the default options that faast.js would use, which are:

- maxAttempts (faast.js default: 6) - region (faast.js default: "us-west-2") - logger (faast.js default: log.awssdk)

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [createCloudWatchLogs?](./faastjs.awsclientfactory.createcloudwatchlogs.md) |  | () =&gt; CloudWatchLogs | _(Optional)_ |
|  [createIAM?](./faastjs.awsclientfactory.createiam.md) |  | () =&gt; IAM | _(Optional)_ |
|  [createLambda?](./faastjs.awsclientfactory.createlambda.md) |  | () =&gt; Lambda | _(Optional)_ |
|  [createLambdaForInvocations?](./faastjs.awsclientfactory.createlambdaforinvocations.md) |  | () =&gt; Lambda | <p>_(Optional)_ A special AWS Lambda factory for creating lambda functions that are used for faast.js invocations. These special clients have the following options set by default in faast.js:</p><p>// Retries are handled by faast.js, not the sdk. maxAttempts: 0,</p> |
|  [createPricing?](./faastjs.awsclientfactory.createpricing.md) |  | () =&gt; Pricing | _(Optional)_ |
|  [createS3?](./faastjs.awsclientfactory.creates3.md) |  | () =&gt; S3 | _(Optional)_ |
|  [createSNS?](./faastjs.awsclientfactory.createsns.md) |  | () =&gt; SNS | _(Optional)_ |
|  [createSQS?](./faastjs.awsclientfactory.createsqs.md) |  | () =&gt; SQS | _(Optional)_ |
|  [createSts?](./faastjs.awsclientfactory.creatests.md) |  | () =&gt; STS | _(Optional)_ |
