---
id: faastjs.commonoptions.timeout
title: CommonOptions.timeout property
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[faastjs](./faastjs.md) &gt; [CommonOptions](./faastjs.commonoptions.md) &gt; [timeout](./faastjs.commonoptions.timeout.md)

## CommonOptions.timeout property

Execution time limit for each invocation, in seconds. Default: 60.

**Signature:**

```typescript
timeout?: number;
```

## Remarks

Each provider has a maximum time limit for how long invocations can run before being automatically terminated (or frozen). The following are the maximum time limits as of February 2019:

- aws: [15 minutes](https://docs.aws.amazon.com/lambda/latest/dg/limits.html)

- local: unlimited

Faast.js has a proactive timeout detection feature. It automatically attempts to detect when the time limit is about to be reached and proactively sends a timeout exception. Faast does this because not all providers reliably send timely feedback when timeouts occur, leaving developers to look through cloud logs. In general faast.js' timeout will be up to 5s earlier than the timeout specified, in order to give time to allow faast.js to send a timeout message. Proactive timeout detection only works with [CommonOptions.childProcess](./faastjs.commonoptions.childprocess.md) set to `true` (the default).
