---
id: faastjs.commonoptions.validateserialization
title: CommonOptions.validateSerialization property
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[faastjs](./faastjs.md) &gt; [CommonOptions](./faastjs.commonoptions.md) &gt; [validateSerialization](./faastjs.commonoptions.validateserialization.md)

## CommonOptions.validateSerialization property

Check arguments and return values from cloud functions are serializable without losing information. Default: true.

**Signature:**

```typescript
validateSerialization?: boolean;
```

## Remarks

Arguments to cloud functions are automatically serialized with `JSON.stringify` with a custom replacer that handles built-in JavaScript types such as `Date` and `Buffer`<!-- -->. Return values go through the same process. Some JavaScript objects cannot be serialized. By default `validateSerialization` will verify that every argument and return value can be serialized and deserialized without losing information. A `FaastError` will be thrown if faast.js detects a problem according to the following procedure:

1. Serialize arguments and return values with `JSON.stringify` using a special `replacer` function.

2. Deserialize the values with `JSON.parse` with a special `reviver` function.

3. Use [assert.deepStringEqual](https://nodejs.org/api/assert.html#assert_assert_deepstrictequal_actual_expected_message) to compare the original object with the deserialized object from step 2.

There is some overhead to this process because each argument is serialized and deserialized, which can be costly if arguments or return values are large.
