---
id: faastjs.commonoptions.webpackoptions
title: CommonOptions.webpackOptions property
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[faastjs](./faastjs.md) &gt; [CommonOptions](./faastjs.commonoptions.md) &gt; [webpackOptions](./faastjs.commonoptions.webpackoptions.md)

## CommonOptions.webpackOptions property

Extra webpack options to use to bundle the code package.

**Signature:**

```typescript
webpackOptions?: webpack.Configuration;
```

## Remarks

By default, faast.js uses webpack to bundle the code package. Webpack automatically handles finding and bundling dependencies, adding source mappings, etc. If you need specialized bundling, use this option to add or override the default webpack configuration. The library [webpack-merge](https://github.com/survivejs/webpack-merge) is used to combine configurations.

```typescript
const config: webpack.Configuration = merge({
    entry,
    mode: "development",
    output: {
        path: "/",
        filename: outputFilename,
        libraryTarget: "commonjs2"
    },
    target: "node",
    resolveLoader: { modules: [__dirname, `${__dirname}/dist`] },
    node: { global: true, __dirname: false, __filename: false }
  },
  webpackOptions);
```
Take care when setting the values of `entry`<!-- -->, `output`<!-- -->, or `resolveLoader`<!-- -->. If these options are overwritten, faast.js may fail to bundle your code. In particular, setting `entry` to an array value will help `webpack-merge` to concatenate its value instead of replacing the value that faast.js inserts for you.

Default:

- aws: `{ externals: [new RegExp("^aws-sdk/?")] }`<!-- -->. In the lambda environment `"aws-sdk"` is available in the ambient environment and does not need to be bundled.

- other providers: `{}`

The `FAAST_PACKAGE_DIR` environment variable can be useful for debugging webpack issues.
