---
id: faastjs.costanalyzer.result.csv
title: CostAnalyzer.Result.csv() method
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[faastjs](./faastjs.md) &gt; [CostAnalyzer](./faastjs.costanalyzer.md) &gt; [Result](./faastjs.costanalyzer.result.md) &gt; [csv](./faastjs.costanalyzer.result.csv.md)

## CostAnalyzer.Result.csv() method

Comma-separated output of cost analyzer. One line per cost analyzer configuration.

**Signature:**

```typescript
csv(): string;
```
**Returns:**

string

## Remarks

The columns are:

- `memory`<!-- -->: The memory size allocated.

- `cloud`<!-- -->: The cloud provider.

- `mode`<!-- -->: See [CommonOptions.mode](./faastjs.commonoptions.mode.md)<!-- -->.

- `options`<!-- -->: A string summarizing other faast.js options applied to the `workload`<!-- -->. See [CommonOptions](./faastjs.commonoptions.md)<!-- -->.

- `completed`<!-- -->: Number of repetitions that successfully completed.

- `errors`<!-- -->: Number of invocations that failed.

- `retries`<!-- -->: Number of retries that were attempted.

- `cost`<!-- -->: The average cost of executing the workload once.

- `executionTime`<!-- -->: the aggregate time spent executing on the provider for all cloud function invocations in the workload. This is averaged across repetitions.

- `executionTimeStdev`<!-- -->: The standard deviation of `executionTime`<!-- -->.

- `billedTime`<!-- -->: the same as `exectionTime`<!-- -->, except rounded up to the next 100ms for each invocation. Usually very close to `executionTime`<!-- -->.
