---
id: faastjs.faast
title: faast() function
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[faastjs](./faastjs.md) &gt; [faast](./faastjs.faast.md)

## faast() function

The main entry point for faast with any provider and only common options.

**Signature:**

```typescript
export declare function faast<M extends object>(provider: Provider, fmodule: M, options?: CommonOptions): Promise<FaastModule<M>>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  provider | [Provider](./faastjs.provider.md) | One of <code>&quot;aws&quot;</code> or <code>&quot;local&quot;</code>. See [Provider](./faastjs.provider.md)<!-- -->. |
|  fmodule | M | A module imported with <code>import * as X from &quot;Y&quot;;</code>. Using <code>require</code> also works but loses type information. |
|  options | [CommonOptions](./faastjs.commonoptions.md) | _(Optional)_ See [CommonOptions](./faastjs.commonoptions.md)<!-- -->. |

**Returns:**

Promise&lt;[FaastModule](./faastjs.faastmodule.md)<!-- -->&lt;M&gt;&gt;

See [FaastModule](./faastjs.faastmodule.md)<!-- -->.

## Remarks

Example of usage:

```typescript
import { faast } from "faastjs";
import * as mod from "./path/to/module";
(async () => {
    const faastModule = await faast("aws", mod);
    try {
        const result = await faastModule.functions.func("arg");
    } finally {
        await faastModule.cleanup();
    }
})();
```
