---
id: faastjs.faasterror
title: FaastError class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[faastjs](./faastjs.md) &gt; [FaastError](./faastjs.faasterror.md)

## FaastError class

FaastError is a subclass of VError (https://github.com/joyent/node-verror). that is thrown by faast.js APIs and cloud function invocations.

**Signature:**

```typescript
export declare class FaastError extends VError 
```
**Extends:** VError

## Remarks

`FaastError` is a subclass of [VError](https://github.com/joyent/node-verror)<!-- -->, which provides an API for nested error handling. The main API is the same as the standard Error class, namely the err.message, err.name, and err.stack properties.

Several static methods on [FaastError](./faastjs.faasterror.md) are inherited from VError:

FaastError.fullStack(err) - property provides a more detailed stack trace that include stack traces of causes in the causal chain.

FaastError.info(err) - returns an object with fields `functionName`<!-- -->, `args`<!-- -->, and `logUrl`<!-- -->. The `logUrl` property is a URL pointing to the logs for a specific invocation that caused the error.`logUrl` will be surrounded by whitespace on both sides to ease parsing as a URL by IDEs.

FaastError.hasCauseWithName(err, cause) - returns true if the FaastError or any of its causes includes an error with the given name, otherwise false. All of the available names are in the enum [FaastErrorNames](./faastjs.faasterrornames.md)<!-- -->. For example, to detect if a FaastError was caused by a cloud function timeout:

```typescript
  FaastError.hasCauseWithName(err, FaastErrorNames.ETIMEOUT)
```
FaastError.findCauseByName(err, cause) - like FaastError.hasCauseWithName() except it returns the Error in the causal chain with the given name instead of a boolean, otherwise null.
