---
id: faastjs.faastmodule
title: FaastModule interface
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[faastjs](./faastjs.md) &gt; [FaastModule](./faastjs.faastmodule.md)

## FaastModule interface

The main interface for invoking, cleaning up, and managing faast.js cloud functions. Returned by [faast()](./faastjs.faast.md)<!-- -->.

**Signature:**

```typescript
export interface FaastModule<M extends object> 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [functions](./faastjs.faastmodule.functions.md) |  | [ProxyModule](./faastjs.proxymodule.md)<!-- -->&lt;M&gt; | Each call of a cloud function creates a separate remote invocation. |
|  [functionsDetail](./faastjs.faastmodule.functionsdetail.md) |  | [ProxyModuleDetail](./faastjs.proxymoduledetail.md)<!-- -->&lt;M&gt; | Similar to [FaastModule.functions](./faastjs.faastmodule.functions.md) except each function returns a [Detail](./faastjs.detail.md) object |
|  [provider](./faastjs.faastmodule.provider.md) |  | [Provider](./faastjs.provider.md) | See [Provider](./faastjs.provider.md)<!-- -->. |

## Methods

|  Method | Description |
|  --- | --- |
|  [cleanup(options)](./faastjs.faastmodule.cleanup.md) | Stop the faast.js runtime for this cloud function and clean up ephemeral cloud resources. |
|  [costSnapshot()](./faastjs.faastmodule.costsnapshot.md) | Get a near real-time cost estimate of cloud function invocations. |
|  [logUrl()](./faastjs.faastmodule.logurl.md) | The URL of logs generated by this cloud function. |
|  [off(name, listener)](./faastjs.faastmodule.off.md) | Deregister a callback for statistics events. |
|  [on(name, listener)](./faastjs.faastmodule.on.md) | Register a callback for statistics events. |
|  [stats(functionName)](./faastjs.faastmodule.stats.md) | Statistics for a specific function or the entire faast.js module. |
