---
id: faastjs
title: faastjs package
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->


## faastjs package

Faast.js transforms ordinary JavaScript modules into serverless cloud functions that can run on AWS Lambda.

The main entry point to faast.js is the [faast()](./faastjs.faast.md) function, which returns an object that implements the [FaastModule](./faastjs.faastmodule.md) interface. The most common options are [CommonOptions](./faastjs.commonoptions.md)<!-- -->. Using faast.js requires writing two modules, one containing the functions to upload to the cloud, and the other that invokes faast.js and calls the resulting cloud functions.

## Classes

|  Class | Description |
|  --- | --- |
|  [CostMetric](./faastjs.costmetric.md) | A line item in the cost estimate, including the resource usage metric measured and its pricing. |
|  [CostSnapshot](./faastjs.costsnapshot.md) | A summary of the costs incurred by a faast.js module at a point in time. Output of [FaastModule.costSnapshot()](./faastjs.faastmodule.costsnapshot.md)<!-- -->. |
|  [FaastError](./faastjs.faasterror.md) | FaastError is a subclass of VError (https://github.com/joyent/node-verror). that is thrown by faast.js APIs and cloud function invocations. |
|  [FaastModuleProxy](./faastjs.faastmoduleproxy.md) | Implementation of [FaastModule](./faastjs.faastmodule.md)<!-- -->. |
|  [FunctionStats](./faastjs.functionstats.md) | Summary statistics for function invocations. |
|  [FunctionStatsEvent](./faastjs.functionstatsevent.md) | Summarize statistics about cloud function invocations. |
|  [PersistentCache](./faastjs.persistentcache.md) | A simple persistent key-value store. Used to implement [Limits.cache](./faastjs.limits.cache.md) for [throttle()](./faastjs.throttle.md)<!-- -->. |
|  [Statistics](./faastjs.statistics.md) | Incrementally updated statistics on a set of values. |

## Enumerations

|  Enumeration | Description |
|  --- | --- |
|  [FaastErrorNames](./faastjs.faasterrornames.md) | Possible FaastError names. See [FaastError](./faastjs.faasterror.md)<!-- -->. To test for errors matching these names, use the static method [FaastError](./faastjs.faasterror.md)<!-- -->.hasCauseWithName(). |

## Functions

|  Function | Description |
|  --- | --- |
|  [faast(provider, fmodule, options)](./faastjs.faast.md) | The main entry point for faast with any provider and only common options. |
|  [faastAws(fmodule, options)](./faastjs.faastaws.md) | The main entry point for faast with AWS provider. |
|  [faastLocal(fmodule, options)](./faastjs.faastlocal.md) | The main entry point for faast with Local provider. |
|  [throttle(limits, fn)](./faastjs.throttle.md) | A decorator for rate limiting, concurrency limiting, retry, memoization, and on-disk caching. See [Limits](./faastjs.limits.md)<!-- -->. |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [AwsClientFactory](./faastjs.awsclientfactory.md) | Factory for AWS service clients, which allows for custom construction and configuration. [AWS Configuration](https://docs.aws.amazon.com/AWSJavaScriptSDK/v3/latest/index.html#configuration)<!-- -->. |
|  [AwsOptions](./faastjs.awsoptions.md) | AWS-specific options for [faastAws()](./faastjs.faastaws.md)<!-- -->. |
|  [CleanupOptions](./faastjs.cleanupoptions.md) | Options that apply to the [FaastModule.cleanup()](./faastjs.faastmodule.cleanup.md) method. |
|  [CommonOptions](./faastjs.commonoptions.md) | Options common across all faast.js providers. Used as argument to [faast()](./faastjs.faast.md)<!-- -->. |
|  [Detail](./faastjs.detail.md) | A function return value with additional detailed information. |
|  [FaastModule](./faastjs.faastmodule.md) | The main interface for invoking, cleaning up, and managing faast.js cloud functions. Returned by [faast()](./faastjs.faast.md)<!-- -->. |
|  [IncludeOption](./faastjs.includeoption.md) | Options for the [CommonOptions.include](./faastjs.commonoptions.include.md) option. |
|  [Limits](./faastjs.limits.md) | Specify [throttle()](./faastjs.throttle.md) limits. These limits shape the way throttle invokes the underlying function. |
|  [LocalOptions](./faastjs.localoptions.md) | Local provider options for [faastLocal()](./faastjs.faastlocal.md)<!-- -->. |

## Namespaces

|  Namespace | Description |
|  --- | --- |
|  [CostAnalyzer](./faastjs.costanalyzer.md) | Analyze the cost of a workload across many provider configurations. |

## Variables

|  Variable | Description |
|  --- | --- |
|  [log](./faastjs.log.md) | Faast.js loggers. |
|  [providers](./faastjs.providers.md) | An array of all available provider. |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [Async](./faastjs.async.md) | <code>Async&lt;T&gt;</code> maps regular values to Promises and Iterators to AsyncIterators, If <code>T</code> is already a Promise or an AsyncIterator, it remains the same. This type is used to infer the return value of cloud functions from the types of the functions in the user's input module. |
|  [AsyncDetail](./faastjs.asyncdetail.md) | <code>AsyncDetail&lt;T&gt;</code> is similar to [Async](./faastjs.async.md) except it maps retun values R to <code>Detail&lt;R&gt;</code>, which is the return value with additional information about each cloud function invocation. |
|  [AwsFaastModule](./faastjs.awsfaastmodule.md) | The return type of [faastAws()](./faastjs.faastaws.md)<!-- -->. See [FaastModuleProxy](./faastjs.faastmoduleproxy.md)<!-- -->. |
|  [AwsRegion](./faastjs.awsregion.md) | Valid AWS [regions](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html)<!-- -->. Not all of these regions have Lambda support. |
|  [LocalFaastModule](./faastjs.localfaastmodule.md) | The return type of [faastLocal()](./faastjs.faastlocal.md)<!-- -->. See [FaastModuleProxy](./faastjs.faastmoduleproxy.md)<!-- -->. |
|  [Provider](./faastjs.provider.md) | The type of all supported cloud providers. |
|  [ProxyModule](./faastjs.proxymodule.md) | <code>ProxyModule&lt;M&gt;</code> is the type of [FaastModule.functions](./faastjs.faastmodule.functions.md)<!-- -->. |
|  [ProxyModuleDetail](./faastjs.proxymoduledetail.md) | Similar to [ProxyModule](./faastjs.proxymodule.md) except each function returns a [Detail](./faastjs.detail.md) object. |
