---
id: faastjs.statistics
title: Statistics class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[faastjs](./faastjs.md) &gt; [Statistics](./faastjs.statistics.md)

## Statistics class

Incrementally updated statistics on a set of values.

**Signature:**

```typescript
export declare class Statistics 
```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(printFixedPrecision)](./faastjs.statistics._constructor_.md) |  | Incrementally track mean, stdev, min, max, of a sequence of values. |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [max](./faastjs.statistics.max.md) |  | number | The maximum value observed. Initialized to <code>Number.NEGATIVE_INFINITY</code>. |
|  [mean](./faastjs.statistics.mean.md) |  | number | The mean (average) of the values observed. |
|  [min](./faastjs.statistics.min.md) |  | number | The minimum value observed. Initialized to <code>Number.POSITIVE_INFINITY</code>. |
|  [printFixedPrecision](./faastjs.statistics.printfixedprecision.md) | <code>protected</code> | number | The number of decimal places to print in [Statistics.toString()](./faastjs.statistics.tostring.md) |
|  [samples](./faastjs.statistics.samples.md) |  | number | Number of values observed. |
|  [stdev](./faastjs.statistics.stdev.md) |  | number | The standard deviation of the values observed. |
|  [variance](./faastjs.statistics.variance.md) |  | number | The variance of the values observed. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [toString()](./faastjs.statistics.tostring.md) |  | Print the mean of the observations seen, with the precision specified in the constructor. |
|  [update(value)](./faastjs.statistics.update.md) |  | Update statistics with a new value in the sequence. |
