## API Report File for "faastjs"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

/// <reference types="node" />

import childProcess from 'child_process';
import { CloudWatchLogs } from '@aws-sdk/client-cloudwatch-logs';
import { CreateFunctionRequest } from '@aws-sdk/client-lambda';
import { default as debug_2 } from 'debug';
import { IAM } from '@aws-sdk/client-iam';
import { Lambda } from '@aws-sdk/client-lambda';
import { Pricing } from '@aws-sdk/client-pricing';
import { S3 } from '@aws-sdk/client-s3';
import { SNS } from '@aws-sdk/client-sns';
import { SQS } from '@aws-sdk/client-sqs';
import { STS } from '@aws-sdk/client-sts';
import { VError } from 'verror';
import webpack from 'webpack';
import { Writable } from 'stream';

// @public
export type Async<T> = T extends AsyncGenerator<infer R> ? AsyncGenerator<R> : T extends Generator<infer R> ? AsyncGenerator<R> : T extends Promise<infer R> ? Promise<R> : Promise<T>;

// @public
export type AsyncDetail<T> = T extends AsyncGenerator<infer R> ? AsyncGenerator<Detail<R>> : T extends Generator<infer R> ? AsyncGenerator<Detail<R>> : T extends Promise<infer R> ? Promise<Detail<R>> : Promise<Detail<T>>;

// @public
export interface AwsClientFactory {
    // (undocumented)
    createCloudWatchLogs?: () => CloudWatchLogs;
    // (undocumented)
    createIAM?: () => IAM;
    // (undocumented)
    createLambda?: () => Lambda;
    createLambdaForInvocations?: () => Lambda;
    // (undocumented)
    createPricing?: () => Pricing;
    // (undocumented)
    createS3?: () => S3;
    // (undocumented)
    createSNS?: () => SNS;
    // (undocumented)
    createSQS?: () => SQS;
    // (undocumented)
    createSts?: () => STS;
}

// Warning: (ae-forgotten-export) The symbol "AwsState" needs to be exported by the entry point index.d.ts
//
// @public
export type AwsFaastModule<M extends object = object> = FaastModuleProxy<M, AwsOptions, AwsState>;

// @public
export interface AwsOptions extends CommonOptions {
    awsClientFactory?: AwsClientFactory;
    awsLambdaOptions?: Partial<CreateFunctionRequest>;
    // Warning: (ae-forgotten-export) The symbol "AwsGcWork" needs to be exported by the entry point index.d.ts
    // Warning: (ae-forgotten-export) The symbol "AwsServices" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    _gcWorker?: (work: AwsGcWork, services: AwsServices) => Promise<void>;
    region?: AwsRegion;
    RoleName?: string;
}

// @public
export type AwsRegion = "us-east-1" | "us-east-2" | "us-west-1" | "us-west-2" | "ca-central-1" | "eu-central-1" | "eu-west-1" | "eu-west-2" | "eu-west-3" | "ap-northeast-1" | "ap-northeast-2" | "ap-northeast-3" | "ap-southeast-1" | "ap-southeast-2" | "ap-south-1" | "sa-east-1";

// @public
export interface CleanupOptions {
    deleteCaches?: boolean;
    deleteResources?: boolean;
    gcTimeout?: number;
}

// @public
export interface CommonOptions {
    childProcess?: boolean;
    childProcessMemoryMb?: number;
    concurrency?: number;
    // @internal
    debugOptions?: {
        [key: string]: boolean;
    };
    description?: string;
    env?: {
        [key: string]: string;
    };
    exclude?: string[];
    gc?: "auto" | "force" | "off";
    include?: (string | IncludeOption)[];
    maxRetries?: number;
    memorySize?: number;
    mode?: "https" | "queue" | "auto";
    packageJson?: string | object;
    rate?: number;
    retentionInDays?: number;
    // @beta
    speculativeRetryThreshold?: number;
    timeout?: number;
    useDependencyCaching?: boolean;
    validateSerialization?: boolean;
    webpackOptions?: webpack.Configuration;
}

// @public
export namespace CostAnalyzer {
    export function analyze<T extends object, A extends string>(userWorkload: Workload<T, A>): Promise<Result<T, A>>;
    const awsConfigurations: Configuration[];
    export type Configuration = {
        provider: "aws";
        options: AwsOptions;
    };
    export interface Estimate<A extends string> {
        config: Configuration;
        costSnapshot: CostSnapshot;
        extraMetrics: WorkloadAttribute<A>;
    }
    export class Result<T extends object, A extends string> {
        // @internal
        constructor(
        workload: Required<Workload<T, A>>,
        estimates: Estimate<A>[]);
        csv(): string;
        readonly estimates: Estimate<A>[];
        readonly workload: Required<Workload<T, A>>;
    }
    export interface Workload<T extends object, A extends string> {
        concurrency?: number;
        configurations?: Configuration[];
        format?: (attr: A, value: number) => string;
        formatCSV?: (attr: A, value: number) => string;
        funcs: T;
        repetitions?: number;
        silent?: boolean;
        summarize?: (summaries: WorkloadAttribute<A>[]) => WorkloadAttribute<A>;
        work: (faastModule: FaastModule<T>) => Promise<WorkloadAttribute<A> | void>;
    }
    export type WorkloadAttribute<A extends string> = {
        [attr in A]: number;
    };
}

// @public
export class CostMetric {
    // Warning: (ae-forgotten-export) The symbol "PropertiesExcept" needs to be exported by the entry point index.d.ts
    // Warning: (ae-forgotten-export) The symbol "AnyFunction" needs to be exported by the entry point index.d.ts
    //
    // @internal
    constructor(arg: PropertiesExcept<CostMetric, AnyFunction>);
    readonly comment?: string;
    cost(): number;
    describeCostOnly(): string;
    readonly informationalOnly?: boolean;
    readonly measured: number;
    readonly name: string;
    readonly pricing: number;
    toString(): string;
    readonly unit: string;
    readonly unitPlural?: string;
}

// @public
export class CostSnapshot {
    // @internal
    constructor(
    provider: string,
    options: CommonOptions | AwsOptions, stats: FunctionStats, costMetrics?: CostMetric[]);
    readonly costMetrics: CostMetric[];
    csv(): string;
    find(name: string): CostMetric | undefined;
    readonly options: CommonOptions | AwsOptions;
    readonly provider: string;
    // @internal (undocumented)
    push(metric: CostMetric): void;
    readonly stats: FunctionStats;
    toString(): string;
    total(): number;
}

// @public
export interface Detail<R> {
    executionId?: string;
    instanceId?: string;
    logUrl?: string;
    value: R;
}

// @public
export function faast<M extends object>(provider: Provider, fmodule: M, options?: CommonOptions): Promise<FaastModule<M>>;

// @public
export function faastAws<M extends object>(fmodule: M, options?: AwsOptions): Promise<AwsFaastModule<M>>;

// @public
export class FaastError extends VError {
}

// @public
export enum FaastErrorNames {
    ECANCEL = "FaastCancelError",
    ECONCURRENCY = "FaastConcurrencyError",
    ECREATE = "FaastCreateFunctionError",
    EEXCEPTION = "UserException",
    EGENERIC = "VError",
    EMEMORY = "FaastOutOfMemoryError",
    ESERIALIZE = "FaastSerializationError",
    ETIMEOUT = "FaastTimeoutError"
}

// @public
export function faastLocal<M extends object>(fmodule: M, options?: LocalOptions): Promise<LocalFaastModule<M>>;

// @public
export interface FaastModule<M extends object> {
    cleanup(options?: CleanupOptions): Promise<void>;
    costSnapshot(): Promise<CostSnapshot>;
    functions: ProxyModule<M>;
    functionsDetail: ProxyModuleDetail<M>;
    logUrl(): string;
    off(name: "stats", listener: (statsEvent: FunctionStatsEvent) => void): void;
    on(name: "stats", listener: (statsEvent: FunctionStatsEvent) => void): void;
    provider: Provider;
    stats(functionName?: string): FunctionStats;
}

// @public
export class FaastModuleProxy<M extends object, O extends CommonOptions, S> implements FaastModule<M> {
    // Warning: (ae-forgotten-export) The symbol "ProviderImpl" needs to be exported by the entry point index.d.ts
    //
    // @internal
    constructor(impl: ProviderImpl<O, S>,
    state: S, fmodule: M, modulePath: string,
    options: Required<CommonOptions>);
    cleanup(userCleanupOptions?: CleanupOptions): Promise<void>;
    costSnapshot(): Promise<CostSnapshot>;
    functions: ProxyModule<M>;
    functionsDetail: ProxyModuleDetail<M>;
    logUrl(): string;
    off(name: "stats", listener: (statsEvent: FunctionStatsEvent) => void): void;
    on(name: "stats", listener: (statsEvent: FunctionStatsEvent) => void): void;
    readonly options: Required<CommonOptions>;
    provider: Provider;
    // @internal (undocumented)
    readonly state: S;
    stats(functionName?: string): FunctionStats;
}

// @public
export class FunctionStats {
    // @internal (undocumented)
    clone(): FunctionStats;
    completed: number;
    errors: number;
    estimatedBilledTime: Statistics;
    executionTime: Statistics;
    invocations: number;
    localStartLatency: Statistics;
    remoteStartLatency: Statistics;
    retries: number;
    returnLatency: Statistics;
    sendResponseLatency: Statistics;
    toString(): string;
}

// @public
export class FunctionStatsEvent {
    // @internal
    constructor(
    fn: string,
    stats: FunctionStats);
    readonly fn: string;
    readonly stats: FunctionStats;
    toString(): string;
}

// @public
export interface IncludeOption {
    cwd?: string;
    path: string;
}

// @public
export interface Limits {
    burst?: number;
    cache?: PersistentCache;
    // @internal
    cancel?: Promise<void>;
    concurrency: number;
    memoize?: boolean;
    rate?: number;
    retry?: number | ((err: any, retries: number) => boolean);
}

// Warning: (ae-forgotten-export) The symbol "LocalState" needs to be exported by the entry point index.d.ts
//
// @public
export type LocalFaastModule<M extends object = object> = FaastModuleProxy<M, LocalOptions, LocalState>;

// @public
export interface LocalOptions extends CommonOptions {
    // @internal (undocumented)
    _gcWorker?: (tempdir: string) => Promise<void>;
}

// @public
export const log: {
    info: debug_2.Debugger;
    minimal: debug_2.Debugger;
    warn: debug_2.Debugger;
    gc: debug_2.Debugger;
    leaks: debug_2.Debugger;
    calls: debug_2.Debugger;
    webpack: debug_2.Debugger;
    provider: debug_2.Debugger;
    awssdk: debug_2.Debugger;
};

// @public
export class PersistentCache {
    constructor(
    dirRelativeToHomeDir: string,
    expiration?: number);
    clear({ leaveEmptyDir }?: {
        leaveEmptyDir?: boolean | undefined;
    }): Promise<void>;
    readonly dir: string;
    readonly dirRelativeToHomeDir: string;
    entries(): Promise<string[]>;
    readonly expiration: number;
    get(key: string): Promise<Buffer | undefined>;
    set(key: string, value: Buffer | string | Uint8Array): Promise<void>;
}

// @public
export type Provider = "aws" | "local";

// @public
export const providers: Provider[];

// @public
export type ProxyModule<M> = {
    [K in keyof M]: M[K] extends (...args: infer A) => infer R ? (...args: A) => Async<R> : never;
};

// @public
export type ProxyModuleDetail<M> = {
    [K in keyof M]: M[K] extends (...args: infer A) => infer R ? (...args: A) => AsyncDetail<R> : never;
};

// @public
export class Statistics {
    constructor(
    printFixedPrecision?: number);
    // @internal (undocumented)
    clone(): Statistics & this;
    max: number;
    mean: number;
    min: number;
    protected printFixedPrecision: number;
    samples: number;
    stdev: number;
    toString(): string;
    update(value: number | undefined): void;
    variance: number;
}

// @public
export function throttle<A extends any[], R>(limits: Limits, fn: (...args: A) => Promise<R>): (...args: A) => Promise<R>;

```
