# Groups

You can define your groups by providing an array of `Group` objects to the `commands` prop. 

It **must** at least have a `key`. The `commands` property is **optional** to support asynchronous loading of commands. 

::alert{type="info"}
Commands are **always** grouped.
::

**Here is an example:**
```vue
<script setup lang="ts">
import { type Group, CmdBar, defineCommand } from 'cmd-bar'

const groups: Group[] = [
  {
    key: 'people',
    commands: [
      {
        key: '1',
        label: 'Command 1',
      },
      // ...
    ],
  },
  {
    key: 'users',
    label: 'Users',
    search: async (q: string) => {
      const { data } = await useFetch(
        `https://dummyjson.com/users/search?q=${q}`
      ).json()
      return data.value.users.map((user: Record<string, any>) =>
        defineCommand({
          key: 'user-' + user.id.toString(),
          label: `${user.firstName} ${user.lastName}`,
          action: () => {
            // Define your action here.
          }
        })
      )
    }
  },
]
</script>

<template>
<CmdBar :commands="groups">
  <CmdBarDialog>
    <template #header>
      <CmdBarInput placeholder="search fo anything" />
    </template>
    <template #content>
      <CmdBarList>
        <template #default="{ command }">
            {{ command.label }}
        </template>
      </CmdBarList>
    </template>
  </CmdBarDialog>
</CmdBar>
</template>
```
