# Filter

Built-in solution to filter the commands. It takes the following props:
- `filterOptions`: An array of `FilterOption` objects.
- `asCheckbox`: Whether it should be possible to select multiple options or not. (Default: `false`)

## FilterOptions

The `groupKey` has to be equal to the `key` of one of your groups.

If you want to **show all commands**, you can set the `groupKey` to `null`.

To **hide** a group, set the `visible` property to `false`.

::alert{type="info"}
If no group is selected, the first group is selected by default.
::

## Emits
Emits a `filterChange` event with an array of `groupKey`s. (@see [useCmdBarEvent composable](../4.composables/1.CmdBarEvent.md))

## Example:
```vue
<script setup lang="ts">
import { type Group,type FilterOption, CmdBar, defineCommand } from 'cmd-bar'

const groups: Group[] = [
    {
        key: 'users',
        commands: [//..],
    },
    {
        key: 'products',
        commands: [//..],
    },
]

const filterOptions: FilterOption[] = [
  {
    groupKey: null,
    label: 'All',
    visible: true
  },
  {
    groupKey: 'users',
    label: 'Users',
    visible: true
  },
  {
    groupKey: 'products',
    label: 'Products',
    visible: false
  }
]
</script>

<template>
  <CmdBar :commands="groups">
    <CmdBarDialog>
      <template #header>
        <div>
          <CmdBarInput placeholder="search fo anything" />
        </div>
        <CmdBarFilter :filter-options="filterOptions" />
      </template>
      <template #content>
        <CmdBarList>
          <template #default="{ command }">
            {{ command.label }}
          </template>
        </CmdBarList>
      </template>
    </CmdBarDialog>
  </CmdBar>
</template>
```
